/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.nav;

import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringUrl;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.UrlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

class PathUrlBuilder
implements MirroringUrl {
    private final String baseUrl;
    private final ListMultimap<String, Object> parameters;
    private final List<String> path;

    PathUrlBuilder(String baseUrl, String ... values) {
        this.baseUrl = StringUtils.appendIfMissing((String)baseUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        this.parameters = ArrayListMultimap.create();
        this.path = (List)Arrays.stream(values).map(UrlUtils::encodeURL).collect(MoreCollectors.toImmutableList());
    }

    PathUrlBuilder(PathUrlBuilder builder, String ... values) {
        this(builder, Arrays.stream(values));
    }

    PathUrlBuilder(PathUrlBuilder builder, Stream<?> values) {
        this.baseUrl = builder.baseUrl;
        this.parameters = ArrayListMultimap.create(builder.parameters);
        ImmutableList.Builder pathBuilder = ImmutableList.builder();
        pathBuilder.addAll(builder.path);
        values.map(UrlUtils::encodeURL).forEach(arg_0 -> ((ImmutableList.Builder)pathBuilder).add(arg_0));
        this.path = pathBuilder.build();
    }

    @Override
    @Nonnull
    public String getAbsolute() {
        return this.appendRelative(this.baseUrl);
    }

    @Override
    @Nonnull
    public String getRelative() {
        return this.appendRelative("/");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof PathUrlBuilder)) {
            return false;
        }
        PathUrlBuilder that = (PathUrlBuilder)o;
        return Objects.equals(this.baseUrl, that.baseUrl) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.baseUrl, this.parameters, this.path);
    }

    @Override
    @Nonnull
    public PathUrlBuilder parameters(@Nonnull Multimap<String, ?> values) {
        this.parameters.putAll(values);
        return this;
    }

    @Override
    @Nonnull
    public PathUrlBuilder parameter(@Nonnull String name, Object value) {
        this.parameters.put((Object)name, value);
        return this;
    }

    @Override
    @Nonnull
    public PathUrlBuilder parameterNotEncoded(@Nonnull String name, Object value) {
        this.parameters.put((Object)name, UrlUtils.dontEncode((Object)value));
        return this;
    }

    @Override
    @Nonnull
    public PathUrlBuilder path(String ... values) {
        return new PathUrlBuilder(this, values);
    }

    @Override
    @Nonnull
    public PathUrlBuilder pathNotEncoded(String ... values) {
        return new PathUrlBuilder(this, Arrays.stream(values).map(UrlUtils::dontEncode));
    }

    private String appendRelative(String url) {
        StringBuilder sb = new StringBuilder(url);
        sb.append(UrlUtils.removeRedundantSlashes((String)StringUtils.join(this.path, (char)'/')));
        if (!this.parameters.isEmpty()) {
            sb.append('?').append(UrlUtils.buildQueryParamsFromMap((Map)this.parameters.asMap()));
        }
        return sb.toString();
    }
}

