/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockCallback;
import com.atlassian.bitbucket.topic.Topic;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public class DefaultRepositoryLockCallback<R>
implements RepositoryLockCallback<R> {
    private final Function<String, R> lockFailure;
    private final Consumer<String> lockRelease;
    private final Function<String, R> lockSuccess;

    private DefaultRepositoryLockCallback(Builder<R> builder) {
        this.lockSuccess = Objects.requireNonNull(builder.lockSuccess, "lockSuccess");
        this.lockFailure = Objects.requireNonNull(builder.lockFailure, "lockFailure");
        this.lockRelease = Objects.requireNonNull(builder.lockRelease, "lockRelease");
    }

    @Override
    @Nonnull
    public R onLockFailure(@Nonnull String lockKey) {
        Objects.requireNonNull(lockKey, "lockKey");
        return this.lockFailure.apply(lockKey);
    }

    @Override
    public void onLockRelease(@Nonnull String lockKey) {
        Objects.requireNonNull(lockKey, "lockKey");
        this.lockRelease.accept(lockKey);
    }

    @Override
    @Nonnull
    public R onLockSuccess(@Nonnull String lockKey) {
        Objects.requireNonNull(lockKey, "lockKey");
        return this.lockSuccess.apply(lockKey);
    }

    public static class Builder<R> {
        private Function<String, R> lockFailure;
        private Consumer<String> lockRelease;
        private Function<String, R> lockSuccess;

        public Builder(Topic<String> repositoryLockReleaseTopic) {
            this.lockRelease = arg_0 -> repositoryLockReleaseTopic.publish(arg_0);
        }

        public Builder() {
        }

        public DefaultRepositoryLockCallback<R> build() {
            return new DefaultRepositoryLockCallback(this);
        }

        public Builder<R> lockFailure(Function<String, R> lockFailure) {
            this.lockFailure = lockFailure;
            return this;
        }

        public Builder<R> lockRelease(Consumer<String> lockRelease) {
            this.lockRelease = lockRelease;
            return this;
        }

        public Builder<R> lockSuccess(Function<String, R> lockSuccess) {
            this.lockSuccess = lockSuccess;
            return this;
        }
    }
}

