/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.dmz.mirror.FarmQueue;
import com.atlassian.bitbucket.dmz.mirror.ReadOnlyFarmQueueRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MinimalExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoryMetadataSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.DefaultFarmQueueRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.InternalUpstreamRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.FarmMetadataOrchestrator;
import com.atlassian.bitbucket.mirroring.MirroringCapabilities;
import com.atlassian.bitbucket.mirroring.RepositoryListMode;
import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.atlassian.bitbucket.mirroring.mirror.SyncLevel;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsChangedEvent;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventListener;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultUpstreamRepositoryService
implements InternalUpstreamRepositoryService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUpstreamRepositoryService.class);
    private final FarmMetadataOrchestrator farmMetadataOrchestrator;
    private final int maxRefChangeQueueDumpSize;
    private final FarmQueue<ExternalProject> projectMetadataQueue;
    private final FarmQueue<FarmSynchronizationRequest> refChangesQueue;
    private final FarmQueue<RepositoryMetadataSynchronizationRequest> repositoryMetadataQueue;
    private final InternalUpstreamService upstreamService;
    private final UpstreamUserHelper securityHelper;

    DefaultUpstreamRepositoryService(FarmMetadataOrchestrator farmMetadataOrchestrator, MirroringConfig mirroringConfig, FarmQueue<ExternalProject> projectMetadataQueue, FarmQueue<FarmSynchronizationRequest> refChangesQueue, FarmQueue<RepositoryMetadataSynchronizationRequest> repositoryMetadataQueue, UpstreamUserHelper securityHelper, InternalUpstreamService upstreamService) {
        this.farmMetadataOrchestrator = farmMetadataOrchestrator;
        this.maxRefChangeQueueDumpSize = mirroringConfig.getMaxRefChangeQueueDumpSize();
        this.projectMetadataQueue = projectMetadataQueue;
        this.refChangesQueue = refChangesQueue;
        this.repositoryMetadataQueue = repositoryMetadataQueue;
        this.securityHelper = securityHelper;
        this.upstreamService = upstreamService;
    }

    @Override
    @Nonnull
    public List<ReadOnlyFarmQueueRequest<FarmSynchronizationRequest>> getRefChangesQueueItems() {
        return (List)this.refChangesQueue.streamItems().limit(this.maxRefChangeQueueDumpSize).collect(MoreCollectors.toImmutableList());
    }

    @Override
    public int getRefChangesQueueSize() {
        return this.refChangesQueue.size();
    }

    @Override
    public void onProjectModified(@Nonnull ExternalProject externalProject) {
        Objects.requireNonNull(externalProject, "externalProject");
        log.debug("Enqueueing for metadata sync of project: {}", (Object)externalProject.getKey());
        if (!this.projectMetadataQueue.offer(new DefaultFarmQueueRequest<ExternalProject>(externalProject))) {
            log.error("{}: Unable to submit request for project modification as queue is full", MirrorDescriptionUtils.describe(externalProject));
        }
    }

    @Override
    public void onRepositoryContentsChanged(@Nonnull MinimalExternalRepository externalRepository, @Nonnull List<RefChange> changes) {
        Objects.requireNonNull(externalRepository, "externalRepository");
        Objects.requireNonNull(changes, "changes");
        log.debug("{}: Enqueueing farm sync event for repository", MirrorDescriptionUtils.describe(externalRepository));
        if (!this.refChangesQueue.offer(new DefaultFarmQueueRequest<FarmSynchronizationRequest>(new FarmSynchronizationRequest(externalRepository.getId())))) {
            log.error("{}: Unable to submit request for Ref Changes as queue is full", MirrorDescriptionUtils.describe(externalRepository));
        }
    }

    @Override
    public void onRepositoryCreated(@Nonnull MinimalExternalRepository externalRepository) {
        Objects.requireNonNull(externalRepository, "externalRepository");
        this.enqueueForMetadataSync(externalRepository, RepositoryMetadataSynchronizationRequest.forCreating(externalRepository));
    }

    @Override
    public void onRepositoryDefaultBranchModified(@Nonnull MinimalExternalRepository externalRepository, @Nonnull String defaultBranchId) {
        this.onRepositoryContentsChanged(externalRepository, new ArrayList<RefChange>());
    }

    @Override
    public void onRepositoryDeleted(@Nonnull MinimalExternalRepository externalRepository) {
        Objects.requireNonNull(externalRepository, "externalRepository");
        this.enqueueForMetadataSync(externalRepository, RepositoryMetadataSynchronizationRequest.forDeleting(externalRepository));
    }

    @Override
    public void onRepositoryModified(@Nonnull MinimalExternalRepository externalRepository) {
        Objects.requireNonNull(externalRepository, "externalRepository");
        this.enqueueForMetadataSync(externalRepository, RepositoryMetadataSynchronizationRequest.forModifying(externalRepository));
    }

    @EventListener
    public void onUpstreamSettingsChanged(UpstreamSettingsChangedEvent event) {
        UpstreamServer upstream = event.getUpstream();
        if (this.settingsChangeNeedsFullSync(event)) {
            this.startSynchronization(upstream, SyncLevel.DEFAULT);
        } else if (this.settingsChangeNeedsSync(event)) {
            if (this.canSyncByProject(upstream)) {
                Set<String> newProjectIds = event.getNewSettings().getMirroredProjectIds();
                HashSet oldProjectIds = Sets.newHashSet();
                if (event.getOldSettings() != null) {
                    oldProjectIds.addAll(event.getOldSettings().getMirroredProjectIds());
                }
                Sets.difference(newProjectIds, (Set)oldProjectIds).forEach(externalProjectId -> this.startProjectSynchronization(upstream, (String)externalProjectId));
                Sets.SetView removedProjectIds = Sets.difference((Set)oldProjectIds, newProjectIds);
                if (!removedProjectIds.isEmpty()) {
                    log.info("Removed projects {} will be cleaned up during full sync", (Object)removedProjectIds);
                }
            } else {
                this.startSynchronization(upstream, SyncLevel.DEFAULT);
            }
        }
    }

    @Override
    public void startSynchronization(@Nonnull UpstreamServer upstream, @Nonnull SyncLevel level) {
        EscalatedSecurityContext securityContext = this.securityHelper.asUserForUpstream(upstream.getId());
        if (securityContext == null) {
            log.warn("No user is defined for upstream '{}'. Skipping synchronization", MirrorDescriptionUtils.describe(upstream));
        } else {
            securityContext.call(() -> {
                this.farmMetadataOrchestrator.synchronizeAll(upstream, level);
                return null;
            });
        }
    }

    private boolean canSyncByProject(UpstreamServer upstream) {
        MirroringCapabilities capabilities = this.upstreamService.getCapabilities(upstream);
        return capabilities != null && capabilities.getRepositoryListModes().contains((Object)RepositoryListMode.BY_PROJECT);
    }

    private void enqueueForMetadataSync(@Nonnull MinimalExternalRepository externalRepository, @Nonnull RepositoryMetadataSynchronizationRequest request) {
        log.debug("{}: Enqueueing request {} for repository", MirrorDescriptionUtils.describe(externalRepository), (Object)request);
        if (!this.repositoryMetadataQueue.offer(new DefaultFarmQueueRequest<RepositoryMetadataSynchronizationRequest>(request))) {
            log.error("{}: Unable to submit request {} for repository as queue is full", MirrorDescriptionUtils.describe(externalRepository), (Object)request);
        }
    }

    private boolean settingsChangeNeedsFullSync(UpstreamSettingsChangedEvent event) {
        if (event.getOldSettings() == null) {
            return true;
        }
        return event.getNewSettings().getMode() == MirroringMode.ALL_PROJECTS && event.getOldSettings().getMode() != MirroringMode.ALL_PROJECTS;
    }

    private boolean settingsChangeNeedsSync(UpstreamSettingsChangedEvent event) {
        return event.getNewSettings().getMode() == MirroringMode.SELECTED_PROJECTS && event.getOldSettings().getMode() == MirroringMode.SELECTED_PROJECTS && !event.getOldSettings().getMirroredProjectIds().equals(event.getNewSettings().getMirroredProjectIds());
    }

    private void startProjectSynchronization(UpstreamServer upstream, String externalProjectId) {
        EscalatedSecurityContext securityContext = this.securityHelper.asUserForUpstream(upstream.getId());
        if (securityContext == null) {
            log.warn("No user is defined for upstream '{}'. Skipping synchronization", MirrorDescriptionUtils.describe(upstream));
        } else {
            securityContext.call(() -> {
                this.farmMetadataOrchestrator.synchronizeProject(upstream, SyncLevel.DEFAULT, externalProjectId);
                return null;
            });
        }
    }
}

