/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.internal.mirroring.mirror.DefaultSyncProgress;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.SyncProgressUpdatedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.ProjectMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.RepositoryMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.UpstreamServerDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.ExternalMappingHelper;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectCreateRequest;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.project.ProjectUpdateRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorProjectService {
    private static final Logger log = LoggerFactory.getLogger(MirrorProjectService.class);
    private final EventPublisher eventPublisher;
    private final ExternalMappingHelper externalMappingHelper;
    private final ProjectMappingDao projectMappingDao;
    private final ProjectService projectService;
    private final RepositoryMappingDao repositoryMappingDao;
    private final RepositoryService repositoryService;
    private final TransactionTemplate transactionTemplate;
    private final UpstreamServerDao upstreamServerDao;
    private final InternalUpstreamService upstreamService;
    private final UpstreamSettingsService upstreamSettingsService;

    @Autowired
    MirrorProjectService(EventPublisher eventPublisher, ExternalMappingHelper externalMappingHelper, ProjectMappingDao projectMappingDao, ProjectService projectService, RepositoryMappingDao repositoryMappingDao, RepositoryService repositoryService, TransactionTemplate transactionTemplate, UpstreamServerDao upstreamServerDao, InternalUpstreamService upstreamService, UpstreamSettingsService upstreamSettingsService) {
        this.eventPublisher = eventPublisher;
        this.externalMappingHelper = externalMappingHelper;
        this.projectMappingDao = projectMappingDao;
        this.projectService = projectService;
        this.repositoryMappingDao = repositoryMappingDao;
        this.repositoryService = repositoryService;
        this.transactionTemplate = transactionTemplate;
        this.upstreamServerDao = upstreamServerDao;
        this.upstreamService = upstreamService;
        this.upstreamSettingsService = upstreamSettingsService;
    }

    public void deleteProjectIfEmpty(@Nonnull String externalProjectId, @Nonnull UpstreamServer upstream) {
        Objects.requireNonNull(externalProjectId, "externalProjectId");
        Objects.requireNonNull(upstream, "upstream");
        this.inTransactionVoid(() -> {
            Project localProject = this.getLocalProject(externalProjectId, upstream);
            this.deleteProjectIfEmpty(localProject);
        });
    }

    public void deleteProjectsWithoutRepositories(@Nonnull UpstreamServer upstream) {
        Objects.requireNonNull(upstream, "upstream");
        this.inTransactionVoid(() -> {
            Set<Integer> allLocalProjectIds = this.projectMappingDao.getLocalIdsByUpstreamId(upstream.getId());
            if (allLocalProjectIds.isEmpty()) {
                return;
            }
            Set<Integer> nonEmptyLocalProjectIds = this.repositoryMappingDao.getLocalProjectIdsByUpstreamId(upstream.getId());
            Sets.SetView emptyLocalProjectIds = Sets.difference(allLocalProjectIds, nonEmptyLocalProjectIds);
            for (Integer projectId : emptyLocalProjectIds) {
                this.deleteProjectIfEmpty(this.projectService.getById(projectId.intValue()));
            }
        });
    }

    @Nullable
    public Project getLocalProject(@Nonnull String externalProjectId, @Nonnull UpstreamServer upstream) {
        Objects.requireNonNull(externalProjectId, "externalProjectId");
        Objects.requireNonNull(upstream, "upstream");
        return (Project)this.transactionTemplate.execute(() -> {
            AoProjectMapping aoMapping = this.projectMappingDao.getByUpstreamId(upstream.getId(), externalProjectId);
            return aoMapping == null ? null : this.projectService.getById(aoMapping.getLocalId().intValue());
        });
    }

    public boolean isProjectSyncing(@Nonnull String externalProjectId, @Nonnull UpstreamServer upstream) {
        Objects.requireNonNull(externalProjectId, "externalProjectId");
        Objects.requireNonNull(upstream, "upstream");
        return (Boolean)this.transactionTemplate.execute(() -> {
            AoProjectMapping aoMapping = this.projectMappingDao.getByUpstreamId(upstream.getId(), externalProjectId);
            if (aoMapping != null) {
                return aoMapping.getInProgress();
            }
            return false;
        });
    }

    @Nonnull
    public AoProjectMapping getByLocalId(int localId) {
        return (AoProjectMapping)this.transactionTemplate.execute(() -> this.projectMappingDao.getByLocalId(localId));
    }

    @Nonnull
    public Page<AoProjectMapping> findAllProjectMappings(@Nullable PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        return (Page)this.transactionTemplate.execute(() -> this.projectMappingDao.findAll(pageRequest));
    }

    @Nonnull
    public Map<String, Integer> mapRepositoryIdsForProject(@Nonnull Project project) {
        Objects.requireNonNull(project, "project");
        return this.mapRepositoryIdsForProject(project.getId());
    }

    @Nonnull
    public Map<String, Integer> mapRepositoryIdsForProject(int localProjectId) {
        return (Map)this.transactionTemplate.execute(() -> this.repositoryMappingDao.mapIdsForLocalProject(localProjectId));
    }

    @Nullable
    public Project syncLocalProject(@Nonnull ExternalProject externalProject, @Nonnull UpstreamServer upstream, boolean createIfMissing) {
        Objects.requireNonNull(externalProject, "externalProject");
        Objects.requireNonNull(upstream, "upstream");
        String upstreamServerId = upstream.getId();
        Pair execution = (Pair)this.transactionTemplate.execute(() -> {
            AoProjectMapping projectMapping = this.projectMappingDao.getByUpstreamId(upstreamServerId, externalProject.getId());
            if (projectMapping == null && !createIfMissing) {
                return ImmutablePair.of(null, (Object)false);
            }
            if (projectMapping != null) {
                Project localProject = this.projectService.getById(projectMapping.getLocalId().intValue());
                if (localProject != null) {
                    return ImmutablePair.of((Object)this.maybeUpdateProject(localProject, projectMapping, externalProject), (Object)false);
                }
                log.warn("{}: A mapping between external project for upstream {} and local project with ID [{}] exists but the local project no longer exists. Deleting the local mapping and reconstructing as necessary", new Object[]{MirrorDescriptionUtils.describe(externalProject), MirrorDescriptionUtils.describe(upstream), projectMapping.getLocalId()});
                this.projectMappingDao.delete(projectMapping.getUpstreamId(), projectMapping.getExternalId());
            }
            return ImmutablePair.of((Object)this.createProjectAndMapping(externalProject, upstream), (Object)true);
        });
        if (((Boolean)execution.getRight()).booleanValue()) {
            this.eventPublisher.publish((Object)new SyncProgressUpdatedEvent(this, new DefaultSyncProgress(this.upstreamServerDao.isDiscovering(upstreamServerId), this.repositoryMappingDao.countSyncedInProgress(upstreamServerId), this.repositoryMappingDao.countAllInProgress(upstreamServerId))));
        }
        return (Project)execution.getLeft();
    }

    void deleteProjectIfEmpty(@Nullable Project project) {
        if (project == null) {
            return;
        }
        if (!this.isEmpty(project)) {
            return;
        }
        this.inTransactionVoid(() -> {
            log.debug("{}: deleting local mapping as project no longer contains mirrored repositories", (Object)project);
            this.projectMappingDao.delete(project.getId());
            log.debug("{}: deleting local project as it no longer contains mirrored repositories", (Object)project);
            this.projectService.delete(project);
        });
    }

    public boolean isMirrored(@Nonnull ExternalProject externalProject) {
        Objects.requireNonNull(externalProject, "externalProject");
        return (Boolean)this.transactionTemplate.execute(() -> {
            InternalUpstreamServer upstreamServer = this.upstreamService.getUpstreamOrFail();
            Optional<UpstreamSettings> settings = this.upstreamSettingsService.getSettings(upstreamServer.getId());
            return settings.map(setting -> setting.isMirrored(externalProject.getId())).orElse(false);
        });
    }

    private Project createProjectAndMapping(ExternalProject externalProject, UpstreamServer upstream) {
        String uniqueProjectKey = this.externalMappingHelper.getUniqueProjectKey(externalProject.getKey(), null);
        String uniqueProjectName = this.externalMappingHelper.getUniqueProjectName(externalProject.getName(), null);
        Project localProject = this.projectService.create(((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)new ProjectCreateRequest.Builder().key(uniqueProjectKey)).name(uniqueProjectName)).publiclyAccessible(externalProject.isPublic())).build());
        this.projectMappingDao.create(localProject.getId(), upstream.getId(), externalProject.getId(), externalProject.getKey(), externalProject.getName());
        log.debug("{}: Created project '{}' to mirror project from upstream server '{}'", new Object[]{MirrorDescriptionUtils.describe(externalProject), localProject.getKey(), MirrorDescriptionUtils.describe(upstream)});
        return localProject;
    }

    private void inTransactionVoid(Runnable r) {
        this.transactionTemplate.execute(() -> {
            r.run();
            return null;
        });
    }

    private boolean isEmpty(@Nonnull Project localProject) {
        return this.repositoryService.findByProjectKey(localProject.getKey(), PageUtils.newRequest((int)0, (int)1)).getSize() == 0;
    }

    private Project maybeUpdateProject(Project project, AoProjectMapping projectMapping, ExternalProject externalProject) {
        String uniqueProjectName;
        String uniqueProjectKey;
        boolean isRenamed;
        ProjectUpdateRequest.Builder builder = new ProjectUpdateRequest.Builder(project);
        boolean needsUpdate = false;
        boolean isRekeyed = !projectMapping.getExternalKey().equalsIgnoreCase(externalProject.getKey());
        boolean bl = isRenamed = !projectMapping.getExternalName().equals(externalProject.getName());
        if (isRekeyed && !(uniqueProjectKey = this.externalMappingHelper.getUniqueProjectKey(externalProject.getKey(), project)).equalsIgnoreCase(project.getKey())) {
            log.info("{}: rekeying to {}", (Object)project, (Object)uniqueProjectKey);
            builder = (ProjectUpdateRequest.Builder)builder.key(uniqueProjectKey);
            needsUpdate = true;
        }
        if (isRenamed && !(uniqueProjectName = this.externalMappingHelper.getUniqueProjectName(externalProject.getName(), project)).equals(project.getName())) {
            log.info("{}: renaming to {}", (Object)project, (Object)uniqueProjectName);
            builder = (ProjectUpdateRequest.Builder)builder.name(uniqueProjectName);
            needsUpdate = true;
        }
        if (externalProject.isPublic() != project.isPublic()) {
            log.debug("{}: changing public flag to {}", (Object)project, (Object)externalProject.isPublic());
            builder.publiclyAccessible(externalProject.isPublic());
            needsUpdate = true;
        }
        Project result = project;
        if (needsUpdate) {
            result = this.projectService.update(builder.build());
        }
        if (isRekeyed || isRenamed) {
            log.debug("{}: setting upstream project mapping to {}[{}]", new Object[]{project, externalProject.getName(), externalProject.getKey()});
            this.projectMappingDao.updateExternalMapping(result.getId(), externalProject.getKey(), externalProject.getName());
        }
        return result;
    }
}

