/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.NamedLink;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public class MirrorRepository {
    private final Collection<NamedLink> cloneLinks;
    private final String externalRepositoryId;
    private final int forkDepth;
    private final Date initialSyncDate;
    private final Date originInitialSyncDate;
    private final Repository repository;
    private final String upstreamCloneUrl;
    private final String upstreamId;

    public MirrorRepository(@Nonnull Collection<NamedLink> cloneLinks, @Nonnull String externalRepositoryId, @Nullable Date originInitialSyncDate, @Nonnull Repository repository, @Nullable Date initialSyncDate, @Nonnull String upstreamCloneUrl, @Nonnull String upstreamId) {
        this.externalRepositoryId = Objects.requireNonNull(externalRepositoryId, "delegate");
        this.originInitialSyncDate = originInitialSyncDate;
        this.initialSyncDate = initialSyncDate;
        this.cloneLinks = Objects.requireNonNull(cloneLinks, "cloneLinks");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.upstreamId = Objects.requireNonNull(upstreamId, "upstreamId");
        this.upstreamCloneUrl = Objects.requireNonNull(upstreamCloneUrl, "upstreamCloneUrl");
        this.forkDepth = MirrorRepository.calculateDepth(Objects.requireNonNull(repository, "repository"));
    }

    public MirrorRepository(@Nonnull String externalRepositoryId, @Nullable Date originInitialSyncDate, @Nonnull Repository repository, @Nullable Date initialSyncDate, @Nonnull String upstreamCloneUrl, @Nonnull String upstreamId) {
        this((Collection<NamedLink>)ImmutableList.of(), externalRepositoryId, originInitialSyncDate, repository, initialSyncDate, upstreamCloneUrl, upstreamId);
    }

    public int getForkDepth() {
        return this.forkDepth;
    }

    @Nonnull
    public String getHierarchyId() {
        return this.repository.getHierarchyId();
    }

    @Nonnull
    public String getId() {
        return this.externalRepositoryId;
    }

    @Nullable
    public Date getInitialSyncDate() {
        return this.initialSyncDate;
    }

    @Nullable
    public Date getOriginInitialSyncDate() {
        return this.originInitialSyncDate;
    }

    @Nonnull
    public Project getProject() {
        return this.repository.getProject();
    }

    @Nonnull
    public Collection<NamedLink> getCloneLinks() {
        return this.cloneLinks;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String getSlug() {
        return this.repository.getSlug();
    }

    @Nonnull
    public String getUpstreamCloneUrl() {
        return this.upstreamCloneUrl;
    }

    @Nonnull
    public String getUpstreamId() {
        return this.upstreamId;
    }

    public boolean isContentSynced() {
        return this.initialSyncDate != null;
    }

    private static int calculateDepth(Repository repository) {
        int depth = 0;
        for (Repository origin = repository.getOrigin(); origin != null; origin = origin.getOrigin()) {
            ++depth;
        }
        return depth;
    }
}

