/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ConflictResults;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ResultVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.SingleResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwner;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerNode;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerQuery;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerResult;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MirrorRepositoryLockQueryService {
    private final RequestReplyTopic<RepositoryLockOwnerQuery, RepositoryLockOwnerResult> topic;

    @Autowired
    public MirrorRepositoryLockQueryService(RequestReplyTopic<RepositoryLockOwnerQuery, RepositoryLockOwnerResult> topic) {
        this.topic = topic;
    }

    @Nonnull
    public Set<RepositoryLockOwnerNode> getAllLockOwners() {
        return this.topic.publish(new RepositoryLockOwnerQuery(null), new RepositoryLockOwnerResultVisitor());
    }

    @Nonnull
    public Optional<RepositoryLockOwnerNode> getLockOwner(@Nonnull String externalRepositoryId) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        Set<RepositoryLockOwnerNode> lockClusterOwners = this.topic.publish(new RepositoryLockOwnerQuery(externalRepositoryId), new RepositoryLockOwnerResultVisitor());
        return Optional.ofNullable((RepositoryLockOwnerNode)Iterables.getFirst(lockClusterOwners, null));
    }

    private static class RepositoryLockOwnerResultVisitor
    implements ResultVisitor<RepositoryLockOwnerResult, Set<RepositoryLockOwnerNode>> {
        private RepositoryLockOwnerResultVisitor() {
        }

        @Override
        @Nonnull
        public Set<RepositoryLockOwnerNode> visit(SingleResult<RepositoryLockOwnerResult> result) {
            RepositoryLockOwnerResult repositoryLockOwnerResult = result.get();
            String nodeId = repositoryLockOwnerResult.nodeId();
            return (Set)repositoryLockOwnerResult.lockOwners().stream().map(lo -> new RepositoryLockOwnerNode(nodeId, (RepositoryLockOwner)lo)).sorted(Comparator.comparing(lockOwnerNode -> lockOwnerNode.owner().externalRepositoryId())).collect(MoreCollectors.toImmutableSet());
        }

        @Override
        @Nonnull
        public Set<RepositoryLockOwnerNode> visit(ConflictResults<RepositoryLockOwnerResult> results) {
            ConcurrentHashMap ownersByRepositoryIds = new ConcurrentHashMap();
            results.getResults().keySet().stream().flatMap(nodeResult -> nodeResult.lockOwners().stream().map(lockOwner -> new RepositoryLockOwnerNode(nodeResult.nodeId(), (RepositoryLockOwner)lockOwner))).forEach(ownerNode -> ownersByRepositoryIds.compute(ownerNode.owner().externalRepositoryId(), (ignored, existingOwnerNode) -> {
                if (existingOwnerNode != null) {
                    return RepositoryLockOwnerResultVisitor.mostRecent(existingOwnerNode, ownerNode);
                }
                return ownerNode;
            }));
            return ImmutableSet.copyOf(ownersByRepositoryIds.values());
        }

        private static RepositoryLockOwnerNode mostRecent(RepositoryLockOwnerNode obj1, RepositoryLockOwnerNode obj2) {
            return (RepositoryLockOwnerNode)Comparators.max((Object)obj1, (Object)obj2, Comparator.comparing(o -> o.owner().lockAcquireTime()));
        }
    }
}

