/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorLockHarvester;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ConflictResults;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ErrorResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ResultVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.SingleResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.TimeoutResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwner;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorRepositoryLockService {
    @VisibleForTesting
    static final String LOCK_PREFIX = "repository:";
    private static final HashSet<String> EMPTY_SET = Sets.newHashSet();
    private static final Logger log = LoggerFactory.getLogger(MirrorRepositoryLockService.class);
    private final RequestReplyTopic<String, HashSet<String>> clusterRepositoryLockQuery;
    private final DmzMirrorLockHarvester lockHarvester;
    private final Map<String, RepositoryLockOwner> lockOwners;
    private final LockService lockService;
    private final Lock readLock;
    private final Lock writeLock;

    @Autowired
    public MirrorRepositoryLockService(DmzMirrorLockHarvester lockHarvester, RequestReplyTopic<String, HashSet<String>> clusterRepositoryLockQuery, LockService lockService) {
        this.lockHarvester = lockHarvester;
        this.clusterRepositoryLockQuery = clusterRepositoryLockQuery;
        this.lockService = lockService;
        this.lockOwners = new ConcurrentHashMap<String, RepositoryLockOwner>();
        ReentrantReadWriteLock reaperLock = new ReentrantReadWriteLock(true);
        this.readLock = reaperLock.readLock();
        this.writeLock = reaperLock.writeLock();
    }

    @Nonnull
    public Optional<RepositoryLockOwner> getLockOwner(@Nonnull String externalRepositoryId) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        return Optional.ofNullable(this.lockOwners.get(externalRepositoryId));
    }

    @Nonnull
    public Set<RepositoryLockOwner> getLockOwners() {
        return ImmutableSet.copyOf(this.lockOwners.values());
    }

    public void harvestStaleLocks(@Nonnull Consumer<String> onLockRelease) {
        Objects.requireNonNull(onLockRelease, "onLockRelease");
        try (LockGuard ignored = LockGuard.lock((Lock)this.writeLock);){
            String localMemberUuid = this.lockHarvester.getLocalMemberUuid();
            Set locksHeld = this.clusterRepositoryLockQuery.publish(localMemberUuid, new LockQueryResultVisitor());
            log.trace("Member: {} holds locks: {}", (Object)localMemberUuid, (Object)locksHeld);
            locksHeld.stream().filter(key -> key.startsWith(LOCK_PREFIX)).forEach(key -> {
                log.warn("Detected stale lock: {}, force unlocking", key);
                this.lockHarvester.forceUnlock(key);
                String externalRepositoryId = key.split(":")[1];
                onLockRelease.accept(externalRepositoryId);
                log.trace("Lock release callback for repository with ID {} executed", (Object)externalRepositoryId);
            });
        }
    }

    @Nonnull
    public <R> R performUsingLock(@Nonnull String externalRepositoryId, @Nonnull RepositoryLockCallback<R> callback) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        Objects.requireNonNull(callback, "callback");
        try (LockGuard ignored = LockGuard.lock((Lock)this.readLock);){
            Lock lock = this.lockService.getLock(LOCK_PREFIX + externalRepositoryId);
            LockGuard lockGuard = LockGuard.tryLock((Lock)lock);
            if (lockGuard != null) {
                R r = this.performOperation(externalRepositoryId, callback, lockGuard);
                return r;
            }
            R r = callback.onLockFailure(externalRepositoryId);
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R performOperation(String externalRepositoryId, RepositoryLockCallback<R> callback, LockGuard lockGuard) {
        try {
            this.lockOwners.put(externalRepositoryId, new RepositoryLockOwner(externalRepositoryId, System.currentTimeMillis(), Thread.currentThread().getName(), MDC.get((String)"a-request-id")));
            R r = callback.onLockSuccess(externalRepositoryId);
            return r;
        }
        finally {
            this.lockOwners.compute(externalRepositoryId, (repoId, lockOwner) -> {
                lockGuard.close();
                return null;
            });
            callback.onLockRelease(externalRepositoryId);
        }
    }

    private static class LockQueryResultVisitor
    implements ResultVisitor<HashSet<String>, HashSet<String>> {
        private LockQueryResultVisitor() {
        }

        @Override
        @Nonnull
        public HashSet<String> visit(SingleResult<HashSet<String>> result) {
            return result.get();
        }

        @Override
        @Nonnull
        public HashSet<String> visit(ConflictResults<HashSet<String>> results) {
            return (HashSet)results.getResults().keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @Override
        @Nonnull
        public HashSet<String> visit(ErrorResult<HashSet<String>> results) {
            log.trace("Error on lock query returning empty result");
            return EMPTY_SET;
        }

        @Override
        @Nonnull
        public HashSet<String> visit(TimeoutResult<HashSet<String>> results) {
            log.trace("Timeout on lock query returning empty result");
            return EMPTY_SET;
        }
    }
}

