/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.dmz.mirror.hash.DmzMirrorHashService;
import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashes;
import com.atlassian.bitbucket.dmz.repository.DmzRepositoryService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MinimalExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClientFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.RepositoryMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorProjectService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositorySynchronizationStatus;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorScmUrlFormatter;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.MirrorBranchHelper;
import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryCreateRequest;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositoryUpdateRequest;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.UnavailableScmException;
import com.atlassian.bitbucket.scm.UnsupportedScmException;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorRepositoryService {
    private static final int PAGE_MAX = 500;
    private static final Logger log = LoggerFactory.getLogger(MirrorRepositoryService.class);
    private final I18nService i18nService;
    private final MirrorBranchHelper mirrorBranchHelper;
    private final DmzMirrorHashService mirrorHashService;
    private final MirrorProjectService mirrorProjectService;
    private final MirrorScmUrlFormatter mirrorScmUrlFormatter;
    private final RepositoryMappingDao repositoryMappingDao;
    private final DmzRepositoryService repositoryService;
    private final ScmService scmService;
    private final TransactionTemplate transactionTemplate;
    private final InternalUpstreamClientFactory upstreamClientFactory;
    private final InternalUpstreamService upstreamService;
    private final UpstreamSettingsService upstreamSettingsService;
    private final UpstreamUserHelper upstreamUserHelper;

    @Autowired
    public MirrorRepositoryService(I18nService i18nService, MirrorBranchHelper mirrorBranchHelper, MirrorProjectService mirrorProjectService, MirrorScmUrlFormatter mirrorScmUrlFormatter, DmzMirrorHashService mirrorHashService, RepositoryMappingDao repositoryMappingDao, DmzRepositoryService repositoryService, ScmService scmService, TransactionTemplate transactionTemplate, InternalUpstreamClientFactory upstreamClientFactory, UpstreamUserHelper upstreamUserHelper, InternalUpstreamService upstreamService, UpstreamSettingsService upstreamSettingsService) {
        this.i18nService = i18nService;
        this.mirrorBranchHelper = mirrorBranchHelper;
        this.mirrorHashService = mirrorHashService;
        this.mirrorProjectService = mirrorProjectService;
        this.mirrorScmUrlFormatter = mirrorScmUrlFormatter;
        this.repositoryMappingDao = repositoryMappingDao;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
        this.transactionTemplate = transactionTemplate;
        this.upstreamClientFactory = upstreamClientFactory;
        this.upstreamUserHelper = upstreamUserHelper;
        this.upstreamService = upstreamService;
        this.upstreamSettingsService = upstreamSettingsService;
    }

    public void deleteRepository(@Nonnull String externalRepoId) {
        Objects.requireNonNull(externalRepoId, "externalRepoId");
        this.transactionTemplate.execute(() -> {
            InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
            AoRepositoryMapping repositoryMapping = this.repositoryMappingDao.getByUpstreamId(upstream.getId(), externalRepoId);
            if (repositoryMapping != null) {
                Repository localRepository = this.repositoryService.getById(repositoryMapping.getLocalId().intValue());
                if (localRepository != null) {
                    log.debug("{}: deleting this repository with ID ({}) in upstream {}", new Object[]{localRepository, repositoryMapping.getExternalId(), MirrorDescriptionUtils.describe(upstream)});
                    this.repositoryMappingDao.delete(repositoryMapping.getUpstreamId(), repositoryMapping.getExternalId());
                    this.repositoryService.delete(localRepository);
                    this.mirrorProjectService.deleteProjectIfEmpty(localRepository.getProject());
                } else {
                    log.info("Local mirror no longer exists for repository with ID ({}) in upstream {} - cleaning up", (Object)repositoryMapping.getExternalId(), MirrorDescriptionUtils.describe(upstream));
                    this.repositoryMappingDao.delete(repositoryMapping.getUpstreamId(), repositoryMapping.getExternalId());
                }
            }
            return null;
        });
    }

    @Nonnull
    public Set<String> getAllLocallyKnownExternalRepositoryIds() {
        return (Set)this.transactionTemplate.execute(() -> {
            InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
            PagedIterable repositoryMappings = new PagedIterable(pageRequest -> this.repositoryMappingDao.findByUpstreamId(upstream.getId(), pageRequest), 500);
            return MoreStreams.streamIterable((Iterable)repositoryMappings).map(AoRepositoryMapping::getExternalId).collect(Collectors.toSet());
        });
    }

    @Nonnull
    public Optional<String> getDefaultBranch(@Nonnull MirrorRepository mirrorRepository) {
        return (Optional)this.upstreamUserHelper.performAsUpstreamUser(mirrorRepository.getUpstreamId(), () -> this.getDefaultBranch(mirrorRepository.getRepository()));
    }

    @Nonnull
    public Optional<String> getDefaultBranch(@Nonnull Repository repository) {
        return this.mirrorBranchHelper.getDefaultBranch(repository);
    }

    @Nonnull
    public ExternalRepository getExternalRepository(@Nonnull String externalRepositoryId) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        ExternalRepository externalRepository = this.upstreamClientFactory.create(upstream).getRepository(externalRepositoryId);
        if (externalRepository == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.mirrored.repository.mirror", new Object[]{externalRepositoryId}), null);
        }
        return externalRepository;
    }

    @Nonnull
    public Set<String> getLocallyKnownExternalRepositoryIdsForProject(@Nonnull String externalProjectId) {
        Objects.requireNonNull(externalProjectId, "externalProjectId");
        return (Set)this.transactionTemplate.execute(() -> {
            InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
            Project localProject = this.mirrorProjectService.getLocalProject(externalProjectId, upstream);
            return localProject != null ? this.repositoryMappingDao.getExternalIdsByLocalProjectId(localProject.getId()) : new HashSet();
        });
    }

    @Nonnull
    public Page<MirrorRepositorySynchronizationStatus> getLocalRepositorySyncStatuses(@Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(pageRequest, "pageRequest");
        return (Page)this.transactionTemplate.execute(() -> {
            String upstreamServerId = this.upstreamService.getUpstreamOrFail().getId();
            Page<AoRepositoryMapping> repositoriesPage = this.repositoryMappingDao.findByUpstreamId(upstreamServerId, pageRequest);
            Set repositoryIds = (Set)MoreStreams.streamIterable((Iterable)repositoriesPage.getValues()).map(AoRepositoryMapping::getLocalId).collect(MoreCollectors.toImmutableSet());
            Map hashes = this.mirrorHashService.mapHashesByRepositoryId(repositoryIds);
            Set syncStatuses = (Set)MoreStreams.streamIterable((Iterable)repositoriesPage.getValues()).map(it -> new MirrorRepositorySynchronizationStatus((AoRepositoryMapping)it, (MirrorHashes)hashes.get(it.getLocalId()))).collect(MoreCollectors.toImmutableSet());
            return PageUtils.createPage((Iterable)syncStatuses, (boolean)repositoriesPage.getIsLastPage(), (PageRequest)pageRequest);
        });
    }

    @Nonnull
    public MirrorRepositorySynchronizationStatus getLocalRepositorySyncStatus(int repositoryId) {
        AoRepositoryMapping repositoryMapping = this.getByLocalId(repositoryId);
        if (repositoryMapping == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.mirrored.repository.mirror", new Object[]{repositoryId}), null);
        }
        Map hashes = this.mirrorHashService.mapHashesByRepositoryId(Collections.singleton(repositoryId));
        return new MirrorRepositorySynchronizationStatus(repositoryMapping, (MirrorHashes)hashes.get(repositoryMapping.getLocalId()));
    }

    @Nonnull
    public MirrorRepository getMirrorRepository(@Nonnull String externalRepositoryId) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        return (MirrorRepository)this.transactionTemplate.execute(() -> {
            InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
            String upstreamServerId = upstream.getId();
            return (MirrorRepository)this.upstreamUserHelper.performAsUpstreamUser(upstreamServerId, () -> {
                Repository repository;
                AoRepositoryMapping repoMapping = this.repositoryMappingDao.getByUpstreamId(upstreamServerId, externalRepositoryId);
                if (repoMapping != null && (repository = this.repositoryService.getById(repoMapping.getLocalId().intValue())) != null) {
                    Date originInitialSyncDate = this.getOriginInitialSyncDate(repository);
                    String upstreamCloneUrl = this.mirrorScmUrlFormatter.formatForUpstream(repoMapping, repository);
                    Set cloneLinks = this.repositoryService.getCloneLinks(new RepositoryCloneLinksRequest.Builder().repository(repository).build());
                    return new MirrorRepository(cloneLinks, externalRepositoryId, originInitialSyncDate, repository, repoMapping.getInitialSyncDate(), upstreamCloneUrl, upstreamServerId);
                }
                throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.mirrored.repository.mirror", new Object[]{externalRepositoryId}), null);
            });
        });
    }

    @Nullable
    public String getOriginId(@Nonnull MirrorRepository mirrorRepository) {
        Objects.requireNonNull(mirrorRepository, "mirrorRepository");
        return (String)this.transactionTemplate.execute(() -> {
            Repository origin = mirrorRepository.getRepository().getOrigin();
            if (origin == null) {
                return null;
            }
            AoRepositoryMapping mapping = this.getByLocalId(origin.getId());
            if (mapping == null) {
                return null;
            }
            return mapping.getExternalId();
        });
    }

    @Nonnull
    public Map<String, Repository> mapToLocalRepositories(@Nonnull Set<String> externalRepositoryIds) {
        Objects.requireNonNull(externalRepositoryIds, "externalRepositoryIds");
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        Map<String, Integer> localRepositoryIds = this.upstreamService.mapToLocalRepositories(upstream.getId(), externalRepositoryIds);
        Map repositories = this.repositoryService.findByIds(new HashSet<Integer>(localRepositoryIds.values()));
        return Maps.filterValues((Map)Maps.transformValues(localRepositoryIds, repositories::get), Objects::nonNull);
    }

    public void streamExternalRepositories(@Nonnull Set<String> externalRepositoryIds, @Nonnull Consumer<ExternalRepository> consumer, @Nonnull Consumer<String> nonExistentRepoIdConsumer) {
        Objects.requireNonNull(externalRepositoryIds, "externalRepositoryIds");
        Objects.requireNonNull(consumer, "consumer");
        Objects.requireNonNull(nonExistentRepoIdConsumer, "nonExistentRepoIdConsumer");
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        externalRepositoryIds.stream().map(id -> {
            try {
                return this.getExternalRepository((String)id);
            }
            catch (NoSuchRepositoryException nsre) {
                log.debug("Repository with ID ({}) doesn't exist on the upstream anymore", id);
                nonExistentRepoIdConsumer.accept((String)id);
                return null;
            }
            catch (Exception e) {
                log.warn("Error retrieving repository with ID ({}) from upstream {}", new Object[]{id, upstream.getBaseUrl(), e});
                return null;
            }
        }).filter(Objects::nonNull).forEach(consumer);
    }

    @Nonnull
    public Stream<ExternalRepository> getRepositories() {
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        UpstreamSettings settings = this.upstreamSettingsService.getSettingsOrFail(upstream.getId());
        InternalUpstreamClient upstreamClient = this.upstreamClientFactory.create(upstream);
        if (settings.getMode() == MirroringMode.ALL_PROJECTS) {
            return upstreamClient.getRepositories();
        }
        return settings.getMirroredProjectIds().stream().flatMap(upstreamClient::getRepositoriesByProjectId);
    }

    @Nonnull
    public Stream<ExternalRepository> getRepositoriesByProjectId(@Nonnull String projectId) {
        Objects.requireNonNull(projectId, "projectId");
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        return this.upstreamClientFactory.create(upstream).getRepositoriesByProjectId(projectId);
    }

    public boolean isLocalRepositoryPresent(@Nonnull String externalRepositoryId) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        return (Boolean)this.transactionTemplate.execute(() -> {
            InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
            String upstreamId = upstream.getId();
            return (Boolean)this.upstreamUserHelper.performAsUpstreamUser(upstreamId, () -> {
                AoRepositoryMapping repositoryMapping = this.repositoryMappingDao.getByUpstreamId(upstreamId, externalRepositoryId);
                if (repositoryMapping != null) {
                    Repository localRepository = this.repositoryService.getById(repositoryMapping.getLocalId().intValue());
                    return localRepository != null;
                }
                return false;
            });
        });
    }

    public boolean isMirrored(@Nonnull MinimalExternalRepository externalRepository) {
        Objects.requireNonNull(externalRepository, "externalRepository");
        try {
            if (!this.scmService.isSupported(externalRepository.getScmId(), ScmFeature.MIRRORS)) {
                return false;
            }
        }
        catch (UnavailableScmException | UnsupportedScmException e) {
            return false;
        }
        return (Boolean)this.transactionTemplate.execute(() -> {
            InternalUpstreamServer upstreamServer = this.upstreamService.getUpstreamOrFail();
            return (Boolean)this.upstreamUserHelper.performAsUpstreamUser(upstreamServer.getId(), () -> this.mirrorProjectService.isMirrored(externalRepository.getProject()));
        });
    }

    @Nullable
    public String mapLocalToExternalRepositoryId(int repositoryId) {
        AoRepositoryMapping mapping = this.getByLocalId(repositoryId);
        if (mapping == null) {
            return null;
        }
        return mapping.getExternalId();
    }

    public void setContentHash(@Nonnull MirrorRepository mirrorRepository) {
        Repository repository = Objects.requireNonNull(mirrorRepository, "mirrorRepository").getRepository();
        this.transactionTemplate.execute(() -> {
            InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail(mirrorRepository.getUpstreamId());
            this.mirrorHashService.updateContentHash(repository);
            return null;
        });
    }

    @Nonnull
    public Repository syncLocalRepository(@Nonnull ExternalRepository externalRepository, @Nonnull Project targetProject, @Nullable Repository parent) {
        Objects.requireNonNull(externalRepository, "externalRepository");
        Objects.requireNonNull(targetProject, "targetProject");
        return (Repository)this.transactionTemplate.execute(() -> {
            Repository localRepository;
            InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
            AoRepositoryMapping mapping = this.repositoryMappingDao.getByUpstreamId(upstream.getId(), externalRepository.getId());
            if (mapping != null) {
                localRepository = this.repositoryService.getById(mapping.getLocalId().intValue());
                if (localRepository != null) {
                    localRepository = this.maybeUpdateRepository(targetProject, localRepository, externalRepository);
                    this.maybeUpdateMetadataHash(localRepository, externalRepository);
                    return localRepository;
                }
                log.warn("{}: A mapping between external repository for upstream {} and local repository with ID [{}] exists but the local repository no longer exists. Deleting the local mapping and reconstructing as necessary", new Object[]{MirrorDescriptionUtils.describe(externalRepository), MirrorDescriptionUtils.describe(upstream), mapping.getLocalId()});
                this.repositoryMappingDao.delete(mapping.getUpstreamId(), mapping.getExternalId());
            }
            this.ensureNonConflictingSlug(externalRepository, targetProject);
            localRepository = parent == null ? this.createRepository(externalRepository, targetProject, externalRepository.getSlug()) : this.forkRepository(externalRepository, targetProject, externalRepository.getSlug(), parent);
            this.maybeUpdateMetadataHash(localRepository, externalRepository);
            this.createRepositoryMapping(externalRepository, upstream, localRepository);
            log.debug("{}: Created repository '{}' to mirror repository from upstream server '{}'", new Object[]{MirrorDescriptionUtils.describe(externalRepository), localRepository, MirrorDescriptionUtils.describe(upstream)});
            return localRepository;
        });
    }

    public void updateDefaultBranch(@Nonnull String externalRepositoryId, @Nonnull String newDefaultBranchId) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        Objects.requireNonNull(newDefaultBranchId, "newDefaultBranchId");
        this.transactionTemplate.execute(() -> {
            Repository localRepository;
            InternalUpstreamServer upstreamServer = this.upstreamService.getUpstreamOrFail();
            AoRepositoryMapping repositoryMapping = this.repositoryMappingDao.getByUpstreamId(upstreamServer.getId(), externalRepositoryId);
            if (repositoryMapping != null && (localRepository = this.repositoryService.getById(repositoryMapping.getLocalId().intValue())) != null) {
                this.mirrorBranchHelper.updateDefaultBranch(newDefaultBranchId, localRepository);
                return null;
            }
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.mirrored.repository.mirror", new Object[]{externalRepositoryId}), null);
        });
    }

    private Repository createRepository(ExternalRepository externalRepository, Project project, String mappedSlug) {
        return this.repositoryService.create(((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)new RepositoryCreateRequest.Builder().name(mappedSlug)).scmId(externalRepository.getScmId()).project(project).publiclyAccessible(externalRepository.isPublic())).build());
    }

    private void createRepositoryMapping(ExternalRepository externalRepository, UpstreamServer upstreamServer, Repository repository) {
        this.repositoryMappingDao.create(repository.getId(), upstreamServer.getId(), repository.getProject().getId(), externalRepository.getId());
    }

    private void ensureNonConflictingSlug(ExternalRepository externalRepository, Project targetProject) {
        try {
            Repository existingRepository = this.repositoryService.getBySlug(targetProject.getKey(), externalRepository.getSlug());
            if (existingRepository != null) {
                log.debug("{}: Found existing repository with the duplicate slug as the repository with upstream ID {}", (Object)existingRepository, (Object)externalRepository.getId());
                AoRepositoryMapping existingRepositoryMapping = this.repositoryMappingDao.getByLocalId(existingRepository.getId());
                if (existingRepositoryMapping != null) {
                    this.streamExternalRepositories((Set<String>)ImmutableSet.of((Object)existingRepositoryMapping.getExternalId()), existingExternalRepo -> {
                        log.warn("Repository with upstream ID {} cannot be synced due to another repository with upstream ID {} having same slug in the same project.", (Object)externalRepository.getId(), (Object)existingExternalRepo.getId());
                        throw new IllegalArgumentException("Repository with upstream ID " + externalRepository.getId() + " cannot be synced due to duplicate slug");
                    }, externalRepoId -> {
                        log.debug("{}: Deleting this repository and it's mapping for upstream repository ID {}", (Object)existingRepository, externalRepoId);
                        this.repositoryMappingDao.delete(existingRepositoryMapping.getUpstreamId(), (String)externalRepoId);
                        this.repositoryService.delete(existingRepository);
                    });
                } else {
                    log.debug("{}: Deleting the repository directly as the mapping doesn't exist", (Object)existingRepository);
                    this.repositoryService.delete(existingRepository);
                }
            }
        }
        catch (RepositoryMovedException repositoryMovedException) {
            // empty catch block
        }
    }

    private Repository forkRepository(ExternalRepository externalRepository, Project project, String mappedSlug, Repository parent) {
        return this.repositoryService.fork(((RepositoryForkRequest.Builder)((RepositoryForkRequest.Builder)new RepositoryForkRequest.Builder(parent).project(project).name(mappedSlug)).publiclyAccessible(externalRepository.isPublic())).build());
    }

    private AoRepositoryMapping getByLocalId(int repositoryId) {
        return (AoRepositoryMapping)this.transactionTemplate.execute(() -> this.repositoryMappingDao.getByLocalId(repositoryId));
    }

    private Date getOriginInitialSyncDate(Repository repository) {
        AoRepositoryMapping originRepoMapping;
        Date originInitialSyncDate = null;
        if (repository.getOrigin() != null && (originRepoMapping = this.repositoryMappingDao.getByLocalId(repository.getOrigin().getId())) != null) {
            originInitialSyncDate = originRepoMapping.getInitialSyncDate();
        }
        return originInitialSyncDate;
    }

    private void maybeUpdateMetadataHash(Repository localRepository, ExternalRepository externalRepository) {
        externalRepository.getMetadataHash().ifPresent(metadataHash -> this.mirrorHashService.setMetadataHash(localRepository, metadataHash));
    }

    private Repository maybeUpdateRepository(Project targetProject, Repository repository, ExternalRepository externalRepository) {
        boolean didReslug;
        RepositoryUpdateRequest.Builder updateRequest = new RepositoryUpdateRequest.Builder(repository);
        Project originalProject = repository.getProject();
        String targetSlug = externalRepository.getSlug();
        String originalSlug = repository.getSlug();
        boolean needsUpdate = false;
        boolean didMove = originalProject.getId() != targetProject.getId();
        boolean bl = didReslug = !originalSlug.equalsIgnoreCase(targetSlug);
        if (didMove) {
            log.info("{}: moving repository to {}", (Object)repository, (Object)targetProject);
            updateRequest = updateRequest.project(targetProject);
            needsUpdate = true;
        }
        if (didReslug) {
            String newRepoSlug = externalRepository.getSlug();
            log.info("{}: renaming to {}", (Object)repository, (Object)newRepoSlug);
            updateRequest = (RepositoryUpdateRequest.Builder)updateRequest.name(newRepoSlug);
            needsUpdate = true;
            this.ensureNonConflictingSlug(externalRepository, targetProject);
        }
        if (repository.isPublic() != externalRepository.isPublic()) {
            log.debug("{}: changing public flag to {}", (Object)repository, (Object)externalRepository.isPublic());
            updateRequest.publiclyAccessible(externalRepository.isPublic());
            needsUpdate = true;
        }
        if (needsUpdate) {
            repository = this.repositoryService.update(updateRequest.build());
            if (didMove) {
                this.repositoryMappingDao.updateProject(repository.getId(), targetProject.getId());
                this.mirrorProjectService.deleteProjectIfEmpty(originalProject);
            }
        }
        return repository;
    }
}

