/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.dmz.mirror.hash.MirrorHashes;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryMapping;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

public class MirrorRepositorySynchronizationStatus {
    private final String externalRepoId;
    private final int failedSyncCount;
    private final MirrorHashes hashes;
    private final Date initialSyncDate;
    private final Date lastSyncDate;
    private final int localProjectId;
    private final int localRepoId;
    private final String upstreamId;

    public MirrorRepositorySynchronizationStatus(@Nonnull AoRepositoryMapping aoRepositoryMapping, @Nullable MirrorHashes hashes) {
        Objects.requireNonNull(aoRepositoryMapping, "aoRepositoryMapping");
        this.externalRepoId = aoRepositoryMapping.getExternalId();
        this.failedSyncCount = aoRepositoryMapping.getFailedSyncCount();
        this.initialSyncDate = aoRepositoryMapping.getInitialSyncDate();
        this.hashes = hashes;
        this.lastSyncDate = aoRepositoryMapping.getLastSyncDate();
        this.localProjectId = aoRepositoryMapping.getLocalProjectId();
        this.localRepoId = aoRepositoryMapping.getLocalId();
        this.upstreamId = aoRepositoryMapping.getUpstreamId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MirrorRepositorySynchronizationStatus that = (MirrorRepositorySynchronizationStatus)o;
        return this.failedSyncCount == that.failedSyncCount && this.localProjectId == that.localProjectId && this.localRepoId == that.localRepoId && this.externalRepoId.equals(that.externalRepoId) && Objects.equals(this.hashes, that.hashes) && Objects.equals(this.initialSyncDate, that.initialSyncDate) && Objects.equals(this.lastSyncDate, that.lastSyncDate) && this.upstreamId.equals(that.upstreamId);
    }

    @Nonnull
    public String getExternalRepoId() {
        return this.externalRepoId;
    }

    public int getFailedSyncCount() {
        return this.failedSyncCount;
    }

    @Nullable
    public MirrorHashes getHashes() {
        return this.hashes;
    }

    @Nullable
    public Date getInitialSyncDate() {
        return this.initialSyncDate;
    }

    @Nullable
    public Date getLastSyncDate() {
        return this.lastSyncDate;
    }

    public int getLocalProjectId() {
        return this.localProjectId;
    }

    public int getLocalRepoId() {
        return this.localRepoId;
    }

    @Nonnull
    public String getUpstreamId() {
        return this.upstreamId;
    }

    public int hashCode() {
        return Objects.hash(this.externalRepoId, this.failedSyncCount, this.hashes, this.initialSyncDate, this.lastSyncDate, this.localProjectId, this.localRepoId, this.upstreamId);
    }
}

