/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.DefaultUpstreamSshSettingService;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.UpstreamSshSettings;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorScmUrlFormatter {
    private static final Logger log = LoggerFactory.getLogger(MirrorScmUrlFormatter.class);
    private final I18nService i18nService;
    private final AoProjectMappingDao projectMappingDao;
    private final DefaultUpstreamSshSettingService upstreamSshSettingService;

    @Autowired
    public MirrorScmUrlFormatter(DefaultUpstreamSshSettingService upstreamSshSettingService, AoProjectMappingDao projectMappingDao, I18nService i18nService) {
        this.upstreamSshSettingService = upstreamSshSettingService;
        this.projectMappingDao = projectMappingDao;
        this.i18nService = i18nService;
    }

    public String formatForUpstream(AoRepositoryMapping repoMapping, Repository repository) {
        AoProjectMapping projectMapping = this.projectMappingDao.getByLocalId(repoMapping.getLocalProjectId());
        if (projectMapping == null) {
            log.debug("No upstream project mapping for repository with ID ({})", (Object)repoMapping.getExternalId());
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.mirroring.scm.request.not.available.detail", new Object[0]);
            throw new NoSuchRepositoryException(message, null);
        }
        UpstreamSshSettings sshSettings = this.upstreamSshSettingService.getSshSettings();
        try {
            URI uri = new URI(sshSettings.getBaseUrl());
            RepositoryUrlFragment repositoryUrlFragment = RepositoryUrlFragment.fromKeyAndSlug((String)projectMapping.getExternalKey(), (String)repository.getSlug());
            String path = repositoryUrlFragment.toPath(uri.getPath());
            return new URI(uri.getScheme(), "git", uri.getHost(), uri.getPort(), path + ".git", uri.getQuery(), uri.getFragment()).toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error calculating upstream clone url", e);
        }
    }
}

