/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.repository;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.operation.MirrorOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryLockService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwner;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerQuery;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerResult;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryLockOwnerQueryOperation
implements MirrorOperation<RepositoryLockOwnerQuery, RepositoryLockOwnerResult> {
    private final ClusterService clusterService;
    private final MirrorRepositoryLockService repositoryLockService;

    @Autowired
    public RepositoryLockOwnerQueryOperation(ClusterService clusterService, MirrorRepositoryLockService repositoryLockService) {
        this.clusterService = clusterService;
        this.repositoryLockService = repositoryLockService;
    }

    @Override
    @Nonnull
    public RepositoryLockOwnerResult perform(@Nonnull RepositoryLockOwnerQuery request) {
        Objects.requireNonNull(request, "request");
        String repositoryId = request.externalRepositoryId();
        String nodeId = this.clusterService.getNodeId();
        if (repositoryId == null) {
            return new RepositoryLockOwnerResult(nodeId, this.repositoryLockService.getLockOwners());
        }
        return this.repositoryLockService.getLockOwner(repositoryId).map(owner -> new RepositoryLockOwnerResult(nodeId, (Set<RepositoryLockOwner>)ImmutableSet.of((Object)owner))).orElseGet(() -> new RepositoryLockOwnerResult(nodeId, Collections.emptySet()));
    }
}

