/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringValidationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestClusterNode;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractFarmNodesResource {
    private final DmzMirrorFarm mirrorFarm;
    private final InternalUpstreamService upstreamService;
    private final MirroringValidationHelper validationHelper;

    public AbstractFarmNodesResource(DmzMirrorFarm mirrorFarm, InternalUpstreamService upstreamService, MirroringValidationHelper validationHelper) {
        this.mirrorFarm = mirrorFarm;
        this.upstreamService = upstreamService;
        this.validationHelper = validationHelper;
    }

    @Operation(description="Retrieves the list of farm nodes in this cluster", summary="Get farm nodes")
    @ApiResponses(value={@ApiResponse(description="The list of farm nodes", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestClusterNode.class)))}, responseCode="200"), @ApiResponse(description="The upstream server could not be found", content={@Content(schema=@Schema(implementation=RestErrors.class))}, responseCode="404")})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getFarmNodes() {
        InternalUpstreamServer upstreamServer = this.upstreamService.getUpstreamOrFail();
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamServer.getId());
        List restClusterNodes = this.mirrorFarm.getNodes().stream().map(RestClusterNode::new).collect(Collectors.toList());
        return Response.ok(restClusterNodes).build();
    }
}

