/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestSyncProgress;
import com.atlassian.bitbucket.mirroring.mirror.SyncProgress;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.core.Response;

public abstract class AbstractProgressResource {
    private final InternalUpstreamService upstreamService;

    protected AbstractProgressResource(InternalUpstreamService upstreamService) {
        this.upstreamService = upstreamService;
    }

    @Operation(description=" Retrieves synchronization progress state.If there's no progress to report, this resource will return <pre><code> {\"discovering\":false,\"syncedRepos\":0,\"totalRepos\":0}</code></pre> If there are repositories in the process of synchronizing, but the precise number hasn't been discovered yet, this resource will return: <pre><code> {\"discovering\":true,\"syncedRepos\":3,\"totalRepos\":100}</code></pre> If there is progress to report and the total number of repositories is known, this resource will return: <pre> <code> {\"discovering\":false,\"syncedRepos\":242,\"totalRepos\":1071}</code> </pre>", summary="Get synchronization progress state")
    @ResponseDocs(value={@ResponseDoc(documentation="the synchronization progress state", representation=RestSyncProgress.class, responseCode=200), @ResponseDoc(documentation="The upstream server could not be found.", restError=true, responseCode=404)})
    @GET
    @CorsAllowed
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getSynchronizationProgress() {
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        SyncProgress progress = this.upstreamService.getSynchronizationProgress(upstream);
        return ResponseFactory.ok((Object)((Object)new RestSyncProgress(progress))).build();
    }
}

