/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestMirroredRepository;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepositoryService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.CorsAllowed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;

public class BaseMirrorRepositoryResource {
    private final MirroredRepositoryService mirroredRepositoryService;

    protected BaseMirrorRepositoryResource(MirroredRepositoryService mirroredRepositoryService) {
        this.mirroredRepositoryService = mirroredRepositoryService;
    }

    @Operation(description="Retrieves all available clone urls for the specified repository.", summary="Get clone URLs")
    @Parameters(value={@Parameter(name="externalRepositoryId", description="the repository ID", in=ParameterIn.PATH)})
    @ResponseDocs(value={@ResponseDoc(documentation="The mirrored repository's information.", representation=RestMirroredRepository.class, responseCode=200), @ResponseDoc(documentation="The upstream server or the repository could not be found.", restError=true, responseCode=404)})
    @GET
    @CorsAllowed
    @Path(value="/{externalRepositoryId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMirroredRepository(@PathParam(value="externalRepositoryId") String externalRepositoryId) {
        return ResponseFactory.ok().entity((Object)new RestMirroredRepository(this.mirroredRepositoryService.getRepository(externalRepositoryId))).build();
    }
}

