/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringValidationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestUpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.atlassian.bitbucket.mirroring.mirror.NoSuchUpstreamException;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsSetRequest;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsUpdateRequest;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.util.List;

public class BaseUpstreamSettingsResource {
    private final I18nService i18nService;
    private final InternalUpstreamService upstreamService;
    private final UpstreamSettingsService upstreamSettingsService;
    private final MirroringValidationHelper validationHelper;

    protected BaseUpstreamSettingsResource(I18nService i18nService, UpstreamSettingsService upstreamSettingsService, MirroringValidationHelper validationHelper, InternalUpstreamService upstreamService) {
        this.i18nService = i18nService;
        this.upstreamService = upstreamService;
        this.upstreamSettingsService = upstreamSettingsService;
        this.validationHelper = validationHelper;
    }

    @Operation(description="Returns the IDs of the projects that the mirror is configured to mirror", summary="Get mirrored project IDs")
    @ResponseDocs(value={@ResponseDoc(documentation="the currently mirrored project IDs", responseCode=200), @ResponseDoc(documentation="When the user is not a service user for the currently registered upstream or doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The upstream server could not be found.", restError=true, responseCode=404)})
    @GET
    @Path(value="projects")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMirroredProjects() {
        String upstreamId = this.getUpstreamId();
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamId);
        return this.upstreamSettingsService.getSettings(upstreamId).map(settings -> ResponseFactory.ok(settings.getMirroredProjectIds()).build()).orElseThrow(() -> this.noSuchUpstream(upstreamId));
    }

    @Operation(description="Gets the current mirror mode", summary="Get mirror mode")
    @ResponseDocs(value={@ResponseDoc(documentation="the current mirror mode", responseCode=200), @ResponseDoc(documentation="When the user is not a service user for the currently registered upstream or doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The upstream server could not be found.", restError=true, responseCode=404)})
    @GET
    @Path(value="mode")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMirrorMode() {
        String upstreamId = this.getUpstreamId();
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamId);
        return this.upstreamSettingsService.getSettings(upstreamId).map(settings -> ResponseFactory.ok((Object)BaseUpstreamSettingsResource.toJsonString(settings.getMode())).build()).orElseThrow(() -> this.noSuchUpstream(upstreamId));
    }

    @Operation(description="Retrieves upstream settings", summary="Get upstream settings")
    @ResponseDocs(value={@ResponseDoc(documentation="the mirror settings", representation=RestUpstreamSettings.class, responseCode=200), @ResponseDoc(documentation="When the user is not a service user for the currently registered upstream or doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The upstream server could not be found.", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getMirrorSettings() {
        String upstreamId = this.getUpstreamId();
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamId);
        return this.upstreamSettingsService.getSettings(upstreamId).map(settings -> ResponseFactory.ok((Object)((Object)new RestUpstreamSettings((UpstreamSettings)settings))).build()).orElseThrow(() -> this.noSuchUpstream(upstreamId));
    }

    @Operation(description="Sets the mirror mode for the specified upstream", summary="Update mirror mode")
    @Parameter(name="modeId", description="the current mirror mode")
    @ResponseDocs(value={@ResponseDoc(documentation="the mode to set", responseCode=200), @ResponseDoc(documentation="When the user is not a service user for the currently registered upstream or doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The provided mode is invalid", responseCode=400, restError=true)})
    @PUT
    @Path(value="mode")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setMirrorMode(String modeId) {
        try {
            String upstreamId = this.getUpstreamId();
            this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamId);
            MirroringMode mode = MirroringMode.fromId(modeId);
            UpstreamSettings settings = this.upstreamSettingsService.updateSettings(new UpstreamSettingsUpdateRequest.Builder(upstreamId).mode(mode).build());
            return ResponseFactory.ok((Object)BaseUpstreamSettingsResource.toJsonString(settings.getMode())).build();
        }
        catch (IllegalArgumentException e) {
            return ResponseFactory.badRequest((String)"mode", (String)e.getLocalizedMessage()).build();
        }
    }

    @Operation(description="Sets the settings for the specified upstream", summary="Update upstream settings")
    @RequestBody(description="the mirror settings to update to", content={@Content(schema=@Schema(implementation=RestUpstreamSettings.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="the updated mirror settings", representation=RestUpstreamSettings.class, responseCode=200), @ResponseDoc(documentation="When the user is not a service user for the currently registered upstream or doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The upstream server could not be found.", restError=true, responseCode=404)})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response setMirrorSettings(RestUpstreamSettings settings) {
        String upstreamId = this.getUpstreamId();
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamId);
        UpstreamSettings updated = this.upstreamSettingsService.setSettings(new UpstreamSettingsSetRequest.Builder(upstreamId).mode(settings.getMode()).projectIds(settings.getProjectIds()).build());
        return ResponseFactory.ok((Object)((Object)new RestUpstreamSettings(updated))).build();
    }

    @Operation(description="Configures the mirror to mirror the provided project", summary="Add project to be mirrored")
    @ResponseDocs(value={@ResponseDoc(documentation="the currently mirrored project IDs", responseCode=200), @ResponseDoc(documentation="When the user is not a service user for the currently registered upstream or doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The upstream server could not be found.", restError=true, responseCode=404)})
    @POST
    @Path(value="projects/{projectId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response startMirroringProject(@PathParam(value="projectId") String projectId) {
        String upstreamId = this.getUpstreamId();
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamId);
        UpstreamSettings settings = this.upstreamSettingsService.updateSettings(new UpstreamSettingsUpdateRequest.Builder(upstreamId).addProjects(projectId, new String[0]).build());
        return ResponseFactory.ok(settings.getMirroredProjectIds()).build();
    }

    @Operation(description="Configures the mirror to mirror the provided projects", summary="Add multiple projects to be mirrored")
    @Parameter(description="a List of project IDs to start mirroring", name="projectsIds")
    @ResponseDocs(value={@ResponseDoc(documentation="the currently mirrored project IDs", responseCode=200), @ResponseDoc(documentation="When the user is not a service user for the currently registered upstream or doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The upstream server could not be found.", restError=true, responseCode=404)})
    @POST
    @Path(value="projects")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response startMirroringProjects(List<String> projectsIds) {
        String upstreamId = this.getUpstreamId();
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamId);
        UpstreamSettings settings = this.upstreamSettingsService.updateSettings(new UpstreamSettingsUpdateRequest.Builder(upstreamId).addProjects(projectsIds).build());
        return ResponseFactory.ok(settings.getMirroredProjectIds()).build();
    }

    @Operation(description="Configures the mirror to no longer mirror the provided project", summary="Stop mirroring project")
    @Parameter(description="the project ID to stop mirroring", name="projectId", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="the request has been processed", responseCode=204), @ResponseDoc(documentation="When the user is not a service user for the currently registered upstream or doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The upstream server could not be found.", restError=true, responseCode=404)})
    @DELETE
    @Path(value="projects/{projectId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response stopMirroringProject(@PathParam(value="projectId") String projectId) {
        String upstreamId = this.getUpstreamId();
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamId);
        this.upstreamSettingsService.updateSettings(new UpstreamSettingsUpdateRequest.Builder(upstreamId).removeProjects(projectId, new String[0]).build());
        return ResponseFactory.noContent().build();
    }

    protected String getUpstreamId() {
        InternalUpstreamServer upstreamServer = this.upstreamService.getUpstreamOrFail();
        return upstreamServer.getId();
    }

    private static String toJsonString(MirroringMode value) {
        return "\"" + value.getId() + "\"";
    }

    private NoSuchUpstreamException noSuchUpstream(String upstreamId) {
        throw new NoSuchUpstreamException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.upstream.server", new Object[]{upstreamId}));
    }
}

