/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.AbstractUpstreamServerResource;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestUpstreamServer;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.google.common.collect.ImmutableList;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="Mirroring (Mirror)")
@UnrestrictedAccess
@Path(value="upstreamServers")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class LegacyUpstreamServerResource
extends AbstractUpstreamServerResource {
    private final InternalUpstreamService upstreamService;

    @Inject
    public LegacyUpstreamServerResource(InternalUpstreamService upstreamService) {
        super(upstreamService);
        this.upstreamService = upstreamService;
    }

    @Operation(hidden=true)
    @Deprecated
    @GET
    @Path(value="{upstreamId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getUpstreamServer(@PathParam(value="upstreamId") String ignored) {
        return super.getUpstreamServer();
    }

    @Operation(hidden=true)
    @Deprecated
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response listUpstreamServers(@BeanParam PageRequestResolver pageRequestResolver) {
        InternalUpstreamServer upstream = this.upstreamService.get();
        Page result = upstream == null ? PageUtils.createEmptyPage((PageRequest)pageRequestResolver.getPageRequest()) : PageUtils.createPage((Iterable)ImmutableList.of((Object)upstream), (boolean)true, (PageRequest)pageRequestResolver.getPageRequest());
        return ResponseFactory.ok().entity((Object)new RestPage(result, RestUpstreamServer::new)).build();
    }
}

