/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringValidationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.BaseUpstreamSettingsResource;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsUpdateRequest;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;

@UnrestrictedAccess
@Path(value="upstreamServers/{upstreamId}/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Hidden
@Deprecated
public class LegacyUpstreamSettingsResource
extends BaseUpstreamSettingsResource {
    private final UpstreamSettingsService upstreamSettingsService;
    private final MirroringValidationHelper validationHelper;

    @Inject
    public LegacyUpstreamSettingsResource(I18nService i18nService, UpstreamSettingsService upstreamSettingsService, MirroringValidationHelper validationHelper, InternalUpstreamService upstreamService) {
        super(i18nService, upstreamSettingsService, validationHelper, upstreamService);
        this.upstreamSettingsService = upstreamSettingsService;
        this.validationHelper = validationHelper;
    }

    @DELETE
    @Path(value="projects")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response stopMirroringProjects(List<String> projectIds) {
        String upstreamId = this.getUpstreamId();
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstreamId);
        this.upstreamSettingsService.updateSettings(new UpstreamSettingsUpdateRequest.Builder(upstreamId).removeProjects(projectIds).build());
        return ResponseFactory.noContent().build();
    }
}

