/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamInstallationParameters;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestMirrorInstalledEvent;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Hidden
@UnrestrictedAccess
@Path(value="lifecycle")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MirrorLifecycleResource {
    private final InternalUpstreamService upstreamService;
    private final Validator validator;

    @Inject
    public MirrorLifecycleResource(InternalUpstreamService upstreamService, Validator validator) {
        this.upstreamService = upstreamService;
        this.validator = validator;
    }

    @Path(value="/installed")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response onInstalled(RestMirrorInstalledEvent event) {
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)event), (Class[])new Class[0]);
        UpstreamInstallationParameters.Builder builder = UpstreamInstallationParameters.builder().handshakeId(event.getHandshakeId()).issuerId(event.getClientKey()).secret(event.getSharedSecret());
        this.upstreamService.onInstalled(builder.build());
        return ResponseFactory.noContent().build();
    }

    @Path(value="/uninstalled")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response onUninstalled() {
        this.upstreamService.onUninstalled(this.upstreamService.getUpstreamOrFail().getId());
        return ResponseFactory.noContent().build();
    }
}

