/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.BaseMirrorRepositoryResource;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestDelayedSyncRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.DelayedSyncRepositoriesQueryService;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepositoryService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Comparator;
import java.util.List;

@Tag(name="Mirroring (Mirror)")
@UnrestrictedAccess
@Path(value="mirrorRepos")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MirrorRepositoryResource
extends BaseMirrorRepositoryResource {
    private final DelayedSyncRepositoriesQueryService delayedSyncRepositoriesQueryService;

    @Inject
    public MirrorRepositoryResource(DelayedSyncRepositoriesQueryService delayedSyncRepositoriesQueryService, MirroredRepositoryService mirroredRepositoryService) {
        super(mirroredRepositoryService);
        this.delayedSyncRepositoriesQueryService = delayedSyncRepositoriesQueryService;
    }

    @Operation(description="Retrieves a list of repositories which have not synced on one or more mirror nodes for at least the threshold time limit after the content was changed in the corresponding upstream repositories. The threshold time limit is defined by a configuration property <code>plugin.mirroring.repository.diagnostics.sync.tolerance</code>. The detection of out of sync repositories is dependent on the timing of a scheduled job which is controlled by a configuration property <code>plugin.mirroring.synchronization.interval</code> which means in worst case it can take upto <code>plugin.mirroring.repository.diagnostics.sync.tolerance</code> + <code>plugin.mirroring.synchronization.interval</code> time to detect an out-of-sync repository.<p>Note: If <code>plugin.mirroring.repository.diagnostics.sync.enabled=false</code> is set on any of the mirror farm nodes, results will not be reported from that node.", summary="Get delayed sync repositories")
    @Parameters(value={@Parameter(description="Returns only those repositories that are delayed for the given duration. The minimum allowed value is the configured value for the property <code>plugin.mirroring.synchronization.interval</code>", in=ParameterIn.QUERY, name="delayThreshold"), @Parameter(description="Limit the number of delayed sync repositories returned, the maximum allowed value is 100", in=ParameterIn.QUERY, name="limit")})
    @ApiResponses(value={@ApiResponse(description="The upstream ID, project key and repository slug of the delayed sync repositories", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestDelayedSyncRepository.class)))}, responseCode="200"), @ApiResponse(description="The currently authenticated user has insufficient permissions to call this resource.", content={@Content(schema=@Schema(implementation=RestErrors.class))}, responseCode="401")})
    @GET
    @Path(value="/delayed-sync")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDelayedSyncRepositories(@QueryParam(value="limit") @DefaultValue(value="25") int limit, @QueryParam(value="delayThreshold") @DefaultValue(value="-1") int delayThresholdSeconds) {
        List<RestDelayedSyncRepository> delayedRepositories = this.delayedSyncRepositoriesQueryService.getDelayedSyncRepositories(limit, delayThresholdSeconds).entrySet().stream().map(e -> {
            Repository repository = (Repository)e.getValue();
            return new RestDelayedSyncRepository((String)e.getKey(), repository.getProject().getKey(), repository.getSlug());
        }).sorted(Comparator.comparing(RestDelayedSyncRepository::getRepositoryId)).toList();
        return Response.ok().entity(delayedRepositories).build();
    }
}

