/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.zdu.MirrorRollingUpgradeService;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.farm.zdu.RestRollingUpgradeState;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Tag(name="Mirroring (Mirror)")
@UnrestrictedAccess
@Path(value="zdu")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MirrorRollingUpgradeResource {
    private final MirrorRollingUpgradeService rollingUpgradeService;

    @Inject
    public MirrorRollingUpgradeResource(MirrorRollingUpgradeService rollingUpgradeService) {
        this.rollingUpgradeService = rollingUpgradeService;
    }

    @Operation(description="Finalizes the ZDU upgrade on the mirror farm denying heterogeneous cluster formation", summary="End ZDU upgrade on mirror farm")
    @ResponseDocs(value={@ResponseDoc(documentation="The state of the rolling upgrade which includes the current version on all the nodes in the farm.", representation=RestRollingUpgradeState.class, responseCode=200), @ResponseDoc(documentation="When the user doesn't have SYS_ADMIN permission", restError=true, responseCode=401)})
    @POST
    @Path(value="end")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response endRollingUpgrade() {
        return Response.ok((Object)((Object)new RestRollingUpgradeState(this.rollingUpgradeService.disableUpgradeMode()))).build();
    }

    @Operation(description="Enables upgrading of individual nodes within the cluster, allowing a heterogeneous cluster formation", summary="Start ZDU upgrade on mirror farm")
    @ResponseDocs(value={@ResponseDoc(documentation="The state of the rolling upgrade which includes the minimum version of all the nodes in the farm.", representation=RestRollingUpgradeState.class, responseCode=200), @ResponseDoc(documentation="When the user doesn't have SYS_ADMIN permission", restError=true, responseCode=401)})
    @POST
    @Path(value="start")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response startRollingUpgrade() {
        return Response.ok((Object)((Object)new RestRollingUpgradeState(this.rollingUpgradeService.enableUpgradeMode()))).build();
    }
}

