/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshController;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@UnrestrictedAccess
@Hidden
@Consumes(value={"application/json"})
@Path(value="mesh/config")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Mirroring (Mirror)")
public class MirrorSidecarConfigResource {
    private final DmzMeshController meshController;
    private final PermissionValidationService permissionValidationService;

    @Inject
    public MirrorSidecarConfigResource(DmzMeshController meshController, PermissionValidationService permissionValidationService) {
        this.meshController = meshController;
        this.permissionValidationService = permissionValidationService;
    }

    @POST
    @Path(value="refresh")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response refresh() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        this.meshController.refreshConfiguration();
        return ResponseFactory.ok().build();
    }
}

