/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.mirror.ReadOnlyFarmQueueRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.InternalUpstreamRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryLockQueryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositorySynchronizationStatus;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerNode;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestMirrorRepositorySynchronizationStatus;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestRefSyncQueue;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestRepositoryLockOwner;
import com.atlassian.bitbucket.internal.mirroring.mirror.vet.RepositorySyncDiagnosticsService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;

@UnrestrictedAccess
@Path(value="supportInfo")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Mirroring (Mirror)")
public class MirrorsSupportResource {
    private final I18nService i18nService;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final PermissionValidationService permissionValidationService;
    private final MirrorRepositoryLockQueryService repositoryLockQueryService;
    private final RepositorySyncDiagnosticsService repositorySyncDiagnosticsService;
    private final InternalUpstreamRepositoryService upstreamRepositoryService;

    @Inject
    public MirrorsSupportResource(MirrorRepositoryService mirrorRepositoryService, PermissionValidationService permissionValidationService, InternalUpstreamRepositoryService upstreamRepositoryService, RepositorySyncDiagnosticsService repositorySyncDiagnosticsService, I18nService i18nService, MirrorRepositoryLockQueryService repositoryLockQueryService) {
        this.i18nService = i18nService;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.permissionValidationService = permissionValidationService;
        this.repositoryLockQueryService = repositoryLockQueryService;
        this.repositorySyncDiagnosticsService = repositorySyncDiagnosticsService;
        this.upstreamRepositoryService = upstreamRepositoryService;
    }

    @Hidden
    @GET
    @Path(value="/out-of-sync-repos/content")
    @Deprecated
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getOutOfSyncRepositories() {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        return Response.ok(this.repositorySyncDiagnosticsService.getLocalDelayedSyncRepositories()).build();
    }

    @Operation(description="Retrieves a list of up to <code>plugin.mirroring.farm.max.ref.change.queue.dump.size</code> items currently in the ref changes queue. The ref changes queue is an internal component of every mirror farm, and is shared between all nodes. When the contents of an upstream repository changes, an item is added to this queue so that the mirror farm nodes know to synchronize. The mirror farm constantly polls and removes items from this queue for processing, so it is empty most of the time.", summary="Get items in ref changes queue")
    @ApiResponses(value={@ApiResponse(description="The contents of the ref changes queue", content={@Content(schema=@Schema(implementation=RestRefSyncQueue.class))}, responseCode="200"), @ApiResponse(description="The currently authenticated user has insufficient permissions to call this resource.", content={@Content(schema=@Schema(implementation=RestErrors.class))}, responseCode="401")})
    @GET
    @Path(value="refChangesQueue")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRefChangesQueue() {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        List<ReadOnlyFarmQueueRequest<FarmSynchronizationRequest>> refChangesQueue = this.upstreamRepositoryService.getRefChangesQueueItems();
        return Response.ok((Object)((Object)new RestRefSyncQueue(refChangesQueue))).build();
    }

    @Operation(description="Retrieves the total number of items currently in the ref changes queue", summary="Get total number of items in ref changes queue")
    @ResponseDocs(value={@ResponseDoc(documentation="The total number of items currently in the ref changes queue", responseCode=200), @ResponseDoc(documentation="When the user doesn't have ADMIN permission", restError=true, responseCode=401)})
    @GET
    @Path(value="refChangesQueue/count")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRefChangesQueueCount() {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        int count = this.upstreamRepositoryService.getRefChangesQueueSize();
        return Response.ok((Object)count).build();
    }

    @Operation(description="Retrieves the information about the process owning the sync lock for this repository. The process owning the lock could be running on any of the nodes in the mirror farm", summary="Get the repository lock owner for the syncing process")
    @ResponseDocs(value={@ResponseDoc(documentation="The information about the repository lock owner for the syncing process, if the lock is currently being held, otherwise an empty response", representation=RestRepositoryLockOwner.class, responseCode=200), @ResponseDoc(documentation="When the user doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist", restError=true, responseCode=404)})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="projectKey", description="The project key"), @Parameter(in=ParameterIn.PATH, name="repositorySlug", description="The repository slug")})
    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/repo-lock-owner")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositoryLockOwner(@BeanParam RepositoryResolver repositoryResolver) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        int localRepositoryId = repositoryResolver.getRepository().getId();
        String externalRepositoryId = this.mirrorRepositoryService.mapLocalToExternalRepositoryId(localRepositoryId);
        if (externalRepositoryId == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.mirrored.repository.mirror", new Object[]{localRepositoryId}), null);
        }
        return this.repositoryLockQueryService.getLockOwner(externalRepositoryId).map(owner -> Response.ok((Object)((Object)new RestRepositoryLockOwner((RepositoryLockOwnerNode)owner)))).orElseGet(() -> Response.ok((Object)((Object)new RestRepositoryLockOwner()))).build();
    }

    @Operation(description="Retrieves the information about all the processes from the all the nodes in the mirror farm owning sync lock for any repository", summary="Get all the repository lock owners for the syncing process")
    @ApiResponses(value={@ApiResponse(description="A list of all the repository lock owners for the syncing process", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestRepositoryLockOwner.class)))}, responseCode="200"), @ApiResponse(description="When the user doesn't have ADMIN permission", content={@Content(schema=@Schema(implementation=RestErrors.class))}, responseCode="401")})
    @GET
    @Path(value="repo-lock-owners")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepositoryLockOwners() {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        return Response.ok(this.repositoryLockQueryService.getAllLockOwners().stream().map(RestRepositoryLockOwner::new).collect(MoreCollectors.toImmutableSet())).build();
    }

    @Operation(description="Retrieves a page of sync statuses of the repositories on this mirror node", summary="Get sync status of repositories")
    @ResponseDocs(value={@ResponseDoc(documentation="The sync status of the repositories on this node", paged=true, representation=RestMirrorRepositorySynchronizationStatus.class, responseCode=200), @ResponseDoc(documentation="When the user doesn't have ADMIN permission", restError=true, responseCode=401)})
    @GET
    @Path(value="repoSyncStatus")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepoSyncStatus(@BeanParam PageRequestResolver pageRequestResolver) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        Page<MirrorRepositorySynchronizationStatus> syncStatuses = this.mirrorRepositoryService.getLocalRepositorySyncStatuses(pageRequestResolver.getPageRequest());
        return Response.ok((Object)new RestPage(syncStatuses, RestMirrorRepositorySynchronizationStatus::new)).build();
    }

    @Operation(description="Retrieves information about an external repository mirrored by the mirror server. Particularly the local ID & external ID of the repository", summary="Gets information about the mirrored repository")
    @ResponseDocs(value={@ResponseDoc(documentation="The sync status of the repository on this node", representation=RestMirrorRepositorySynchronizationStatus.class, responseCode=200), @ResponseDoc(documentation="When the user doesn't have ADMIN permission", restError=true, responseCode=401), @ResponseDoc(documentation="The specified repository does not exist", restError=true, responseCode=404)})
    @Parameters(value={@Parameter(in=ParameterIn.PATH, name="projectKey", description="The project key"), @Parameter(in=ParameterIn.PATH, name="repositorySlug", description="The repository slug")})
    @GET
    @Path(value="projects/{projectKey}/repos/{repositorySlug}/repoSyncStatus")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRepoSyncStatus(@BeanParam RepositoryResolver repositoryResolver) {
        this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        MirrorRepositorySynchronizationStatus repoStatus = this.mirrorRepositoryService.getLocalRepositorySyncStatus(repositoryResolver.getRepository().getId());
        return Response.ok((Object)((Object)new RestMirrorRepositorySynchronizationStatus(repoStatus))).build();
    }
}

