/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.bitbucket.cluster.ClusterNode;
import com.atlassian.bitbucket.dmz.cluster.MirrorClusterNode;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.PackedSyncProgress;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestSyncProgress;
import com.atlassian.bitbucket.rest.v2.api.RestLinkedMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.net.InetSocketAddress;
import java.util.Map;

@JsonSerialize
@JsonSurrogate(value=ClusterNode.class)
public class RestClusterNode
extends RestLinkedMapEntity {
    private static final String ID = "id";
    private static final String VM_ID = "vmId";
    private static final String NAME = "name";
    private static final String ADDRESS = "address";
    private static final String LOCAL = "local";
    private static final String FULLY_STARTED = "fullyStarted";
    private static final String STATE = "state";
    private static final String LAST_SYNCHRONIZED = "lastSynchronized";
    private static final String SYNC_PROGRESS = "syncProgress";

    public RestClusterNode() {
    }

    public RestClusterNode(Map<String, ?> values) {
        super(values);
    }

    public RestClusterNode(MirrorClusterNode node) {
        this.put(ID, node.getId());
        this.put(VM_ID, node.getVmId());
        this.put(NAME, node.getName());
        this.put(ADDRESS, RestClusterNode.toString(node.getAddress()));
        this.put(LOCAL, node.isLocal());
        this.put(FULLY_STARTED, node.isFullyStarted());
        node.getSynchronizationState().ifPresent(state -> this.put(STATE, state));
        node.getLastSynchronized().ifPresent(lastSynchronized -> this.put(LAST_SYNCHRONIZED, lastSynchronized.toEpochMilli()));
        this.put(SYNC_PROGRESS, (Object)new RestSyncProgress(PackedSyncProgress.fromValue(node.getLongAttribute(SYNC_PROGRESS).orElse(0L))));
    }

    private static String toString(InetSocketAddress socketAddress) {
        if (socketAddress.isUnresolved()) {
            return socketAddress.getHostName() + ":" + socketAddress.getPort();
        }
        return socketAddress.getAddress().toString() + ":" + socketAddress.getPort();
    }

    @Schema(example="/127.0.0.1:5901")
    public String getAddress() {
        return this.getStringProperty(ADDRESS);
    }

    @Schema(example="5e5b25e0-85e0-4228-b48e-8c2b10165f10")
    public String getID() {
        return this.getStringProperty(ID);
    }

    @Nullable
    public Long getLastSynchronized() {
        if (super.containsKey((Object)LAST_SYNCHRONIZED)) {
            return this.getLongProperty(LAST_SYNCHRONIZED);
        }
        return null;
    }

    @Schema(example="node-1")
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Schema(example="SYNCHRONIZED")
    @Nullable
    public String getState() {
        return this.getStringProperty(STATE);
    }

    public RestSyncProgress getSyncProgress() {
        return (RestSyncProgress)((Object)this.get(SYNC_PROGRESS));
    }

    @Schema(example="8829ac68-6c37-48a9-92a0-a4671f1474fc")
    public String getVmId() {
        return this.getStringProperty(VM_ID);
    }

    public boolean isFullyStarted() {
        return this.getBoolProperty(FULLY_STARTED);
    }

    public boolean isLocal() {
        return this.getBoolProperty(LOCAL);
    }
}

