/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonSerialize
public class RestDelayedSyncRepository
extends RestMapEntity {
    private static final String PROJECT_KEY = "projectKey";
    private static final String REPOSITORY_ID = "repositoryId";
    private static final String REPOSITORY_SLUG = "repositorySlug";

    public RestDelayedSyncRepository(@Nonnull String externalRepositoryId, @Nullable String projectKey, @Nullable String repositorySlug) {
        this.put(REPOSITORY_ID, Objects.requireNonNull(externalRepositoryId, "externalRepositoryId"));
        this.put(PROJECT_KEY, Objects.requireNonNull(projectKey, PROJECT_KEY));
        this.put(REPOSITORY_SLUG, Objects.requireNonNull(repositorySlug, REPOSITORY_SLUG));
    }

    @Schema(example="PRJ")
    @Nonnull
    public String getProjectKey() {
        return this.getStringProperty(PROJECT_KEY);
    }

    @Schema(example="1")
    @Nonnull
    public String getRepositoryId() {
        return this.getStringProperty(REPOSITORY_ID);
    }

    @Schema(example="my-repo")
    @Nonnull
    public String getRepositorySlug() {
        return this.getStringProperty(REPOSITORY_SLUG);
    }
}

