/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.bitbucket.dmz.mirror.ReadOnlyFarmQueueRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FarmSynchronizationRequest;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.scm.mirror.RepositorySynchronizationType;
import io.swagger.v3.oas.annotations.media.Schema;

public class RestFarmSynchronizationRequest
extends RestMapEntity {
    private static final String ATTEMPT = "attempt";
    private static final String CREATED_AT = "createdAt";
    private static final String EXTERNAL_REPO_ID = "externalRepositoryId";
    private static final String TYPE = "type";

    public RestFarmSynchronizationRequest(ReadOnlyFarmQueueRequest<FarmSynchronizationRequest> request) {
        this.put(ATTEMPT, request.getAttempt());
        FarmSynchronizationRequest syncRequest = (FarmSynchronizationRequest)request.getValue();
        this.put(CREATED_AT, syncRequest.getCreatedAt().toString());
        this.put(EXTERNAL_REPO_ID, syncRequest.getExternalRepositoryId());
        this.put(TYPE, syncRequest.getType());
    }

    @Schema(example="1")
    public int getAttempt() {
        return this.getIntProperty(ATTEMPT);
    }

    @Schema(example="2022-08-18T02:04:46.435Z")
    public String getCreatedAt() {
        return this.getStringProperty(CREATED_AT);
    }

    @Schema(example="1")
    public String getExternalRepoId() {
        return this.getStringProperty(EXTERNAL_REPO_ID);
    }

    @Schema(example="INCREMENTAL")
    public RepositorySynchronizationType getType() {
        return (RepositorySynchronizationType)this.getEnumProperty(TYPE, RepositorySynchronizationType.class);
    }
}

