/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;

public class RestMirrorInstalledEvent
extends RestMapEntity {
    private static final String CLIENT_KEY = "clientKey";
    private static final String HANDSHAKE_ID = "handshakeId";
    private static final String SHARED_SECRET = "sharedSecret";

    public RestMirrorInstalledEvent() {
    }

    @VisibleForTesting
    RestMirrorInstalledEvent(String issuerId, String sharedSecret, String handshakeId) {
        this.put(CLIENT_KEY, issuerId);
        this.putIfNotNull(HANDSHAKE_ID, handshakeId);
        this.put(SHARED_SECRET, sharedSecret);
    }

    @Schema(example="bitbucket:238782372863")
    @NotBlank(message="{bitbucket.mirroring.rest.oninstalled.invalid}")
    public @NotBlank(message="{bitbucket.mirroring.rest.oninstalled.invalid}") String getClientKey() {
        return this.getStringProperty(CLIENT_KEY);
    }

    @Schema(example="42424242-4242-4242-4242-424242424242")
    @OptionalString(message="{bitbucket.mirroring.rest.oninstalled.invalid}")
    public String getHandshakeId() {
        return this.getStringProperty(HANDSHAKE_ID);
    }

    @Schema(example="424242")
    @NotBlank(message="{bitbucket.mirroring.rest.oninstalled.invalid}")
    public @NotBlank(message="{bitbucket.mirroring.rest.oninstalled.invalid}") String getSharedSecret() {
        return this.getStringProperty(SHARED_SECRET);
    }
}

