/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositorySynchronizationStatus;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestMirrorHashes;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;

@JsonSerialize
@JsonSurrogate(value=MirrorRepositorySynchronizationStatus.class)
public class RestMirrorRepositorySynchronizationStatus
extends RestMapEntity {
    private static final String EXTERNAL_REPO_ID = "externalRepoId";
    private static final String FAILED_SYNC_COUNT = "failedSyncCount";
    private static final String HASHES = "hashes";
    private static final String INITIAL_SYNC_DATE = "initialSyncDate";
    private static final String LAST_SYNC_DATE = "lastSyncDate";
    private static final String LOCAL_PROJECT_ID = "localProjectId";
    private static final String LOCAL_REPO_ID = "localRepoId";
    private static final String UPSTREAM_ID = "upstreamId";

    public RestMirrorRepositorySynchronizationStatus(MirrorRepositorySynchronizationStatus syncStatus) {
        this.put(EXTERNAL_REPO_ID, syncStatus.getExternalRepoId());
        this.put(FAILED_SYNC_COUNT, syncStatus.getFailedSyncCount());
        this.putIfNotNull(HASHES, (Object)(syncStatus.getHashes() != null ? new RestMirrorHashes(syncStatus.getHashes()) : null));
        this.putIfNotNull(INITIAL_SYNC_DATE, syncStatus.getInitialSyncDate());
        this.putIfNotNull(LAST_SYNC_DATE, syncStatus.getLastSyncDate());
        this.put(LOCAL_REPO_ID, syncStatus.getLocalRepoId());
        this.put(LOCAL_PROJECT_ID, syncStatus.getLocalProjectId());
        this.put(UPSTREAM_ID, syncStatus.getUpstreamId());
    }

    @Nonnull
    @Schema(example="1")
    public String getExternalRepoId() {
        return this.getStringProperty(EXTERNAL_REPO_ID);
    }

    @Schema(example="1")
    public int getFailedSyncCount() {
        return this.getIntProperty(FAILED_SYNC_COUNT);
    }

    @Nullable
    @Schema(implementation=RestMirrorHashes.class)
    public RestMirrorHashes getHashes() {
        return (RestMirrorHashes)((Object)this.get(HASHES));
    }

    @Nullable
    @Schema(example="1664938839418")
    public Date getInitialSyncDate() {
        return (Date)this.get(INITIAL_SYNC_DATE);
    }

    @Nullable
    @Schema(example="1664938845801")
    public Date getLastSyncDate() {
        return (Date)this.get(LAST_SYNC_DATE);
    }

    @Schema(example="1")
    public int getLocalProjectId() {
        return this.getIntProperty(LOCAL_PROJECT_ID);
    }

    @Schema(example="1")
    public int getLocalRepoId() {
        return this.getIntProperty(LOCAL_REPO_ID);
    }

    @Nonnull
    @Schema(example="148728f5-df0f-3f3e-af11-5ca16be3725f")
    public String getUpstreamId() {
        return this.getStringProperty(UPSTREAM_ID);
    }
}

