/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.bitbucket.mirroring.mirror.MirroredRepository;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepositoryStatus;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.util.RestNamedLink;
import com.atlassian.bitbucket.util.NamedLink;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@JsonSerialize
@JsonSurrogate(value=MirroredRepository.class)
public class RestMirroredRepository
extends RestMapEntity
implements MirroredRepository {
    public static final String AVAILABLE = "available";
    public static final String LINKS = "links";
    public static final String MIRROR_NAME = "mirrorName";
    public static final String UPDATED_DATE = "updatedDate";
    public static final String REPOSITORY_ID = "repositoryId";
    public static final String STATUS = "status";

    private RestMirroredRepository(String mirrorName, String upstreamRepoId, Set<RestNamedLink> cloneUrls, Set<RestNamedLink> pushUrls, MirroredRepositoryStatus status, Optional<Date> updatedDate) {
        this.put(AVAILABLE, status == MirroredRepositoryStatus.AVAILABLE || status == MirroredRepositoryStatus.ERROR_AVAILABLE);
        this.put(LINKS, ImmutableMap.of((Object)"clone", cloneUrls, (Object)"push", pushUrls));
        this.put(MIRROR_NAME, mirrorName);
        this.put(REPOSITORY_ID, upstreamRepoId);
        this.put(STATUS, (Object)status);
        this.putIfNotNull(UPDATED_DATE, updatedDate.orElse(null));
    }

    public RestMirroredRepository(@Nonnull MirroredRepository info) {
        this(Objects.requireNonNull(info, "mirroredRepository").getMirrorName(), info.getRepositoryId(), info.getCloneUrls().stream().map(RestNamedLink::new).collect(Collectors.toSet()), info.getPushUrls().stream().map(RestNamedLink::new).collect(Collectors.toSet()), info.getStatus(), info.getLastUpdated());
    }

    @Override
    @ArraySchema(schema=@Schema(implementation=RestNamedLink.class))
    @Nonnull
    public Set<NamedLink> getCloneUrls() {
        return this.getLinks("clone");
    }

    @Override
    @Schema(example="Saigon Mirror")
    @Nonnull
    public String getMirrorName() {
        return this.getStringProperty(MIRROR_NAME);
    }

    @Override
    @Nonnull
    public Optional<Date> getLastUpdated() {
        Date updatedDate = (Date)this.get(UPDATED_DATE);
        return updatedDate != null ? Optional.of(updatedDate) : Optional.empty();
    }

    @Override
    @ArraySchema(schema=@Schema(implementation=RestNamedLink.class))
    @Nonnull
    public Set<NamedLink> getPushUrls() {
        return this.getLinks("push");
    }

    @Override
    @Schema(example="1")
    @Nonnull
    public String getRepositoryId() {
        return this.getStringProperty(REPOSITORY_ID);
    }

    @Override
    @Nonnull
    public MirroredRepositoryStatus getStatus() {
        return (MirroredRepositoryStatus)this.getEnumProperty(STATUS, MirroredRepositoryStatus.class);
    }

    @Override
    public boolean isAvailable() {
        return this.getBoolProperty(AVAILABLE);
    }

    private Set<NamedLink> getLinks(String push) {
        Map namedLinks = (Map)this.get(LINKS);
        if (namedLinks != null) {
            return (Set)namedLinks.get(push);
        }
        return Collections.emptySet();
    }
}

