/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwner;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.RepositoryLockOwnerNode;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

@JsonSerialize
public class RestRepositoryLockOwner
extends RestMapEntity {
    private static final String EXTERNAL_REPOSITORY_ID = "externalRepositoryId";
    private static final String LOCK_ACQUIRE_TIME = "lockAcquireTime";
    private static final String NODE_ID = "nodeId";
    private static final String REQUEST_ID = "requestId";
    private static final String THREAD_NAME = "threadName";

    public RestRepositoryLockOwner() {
    }

    public RestRepositoryLockOwner(@Nonnull RepositoryLockOwnerNode repositoryLockOwnerNode) {
        Objects.requireNonNull(repositoryLockOwnerNode, "repositoryLockOwnerNode");
        RepositoryLockOwner owner = repositoryLockOwnerNode.owner();
        this.put(EXTERNAL_REPOSITORY_ID, owner.externalRepositoryId());
        this.put(NODE_ID, repositoryLockOwnerNode.nodeId());
        this.putIfNotNull(REQUEST_ID, owner.requestId());
        this.put(THREAD_NAME, owner.threadName());
        this.put(LOCK_ACQUIRE_TIME, new Date(owner.lockAcquireTime()));
    }

    @Nonnull
    @Schema(description="The repository ID for which the lock is held", example="101")
    public String getExternalRepositoryId() {
        return this.getStringProperty(EXTERNAL_REPOSITORY_ID);
    }

    @Nonnull
    @Schema(description="The time at which lock was last acquired", example="1664938839418")
    public Date getLockAcquireTime() {
        return (Date)this.get(LOCK_ACQUIRE_TIME);
    }

    @Nonnull
    @Schema(description="The ID of the mirror node on which the lock is being held", example="4da47d83-ec95-489d-ad46-012cc086c0da")
    public String getNodeId() {
        return this.getStringProperty(NODE_ID);
    }

    @Nullable
    @Schema(description="The unique ID of the request for which the lock is being held", example="*T75X1Tx955x782x0")
    public String getRequestId() {
        return this.getStringProperty(REQUEST_ID);
    }

    @Nonnull
    @Schema(description="Name of the thread that is holding the lock", example="farm-refchange-poller:thread-2")
    public String getThreadName() {
        return this.getStringProperty(THREAD_NAME);
    }
}

