/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@JsonSerialize
@JsonSurrogate(value=UpstreamServer.class)
public class RestUpstreamServer
extends RestMapEntity {
    public static final String BASEURL = "baseUrl";
    public static final String ID = "id";
    public static final String STATE = "state";

    private RestUpstreamServer(String id, String baseUrl, IntegrationState state) {
        this.put(ID, id);
        this.put(BASEURL, baseUrl);
        this.put(STATE, state.getId());
    }

    public RestUpstreamServer(@Nonnull UpstreamServer upstream) {
        this(Objects.requireNonNull(upstream, "upstream").getId(), upstream.getBaseUrl(), upstream.getState());
    }

    @Schema(example="https://bitbucket.example.com")
    @RequiredString(size=255)
    public String getBaseUrl() {
        return this.getStringProperty(BASEURL);
    }

    @Schema(example="f76a35c5-4592-425d-bf85-b4d9db68e809")
    @RequiredString(size=64)
    public String getId() {
        return this.getStringProperty(ID);
    }

    @Schema(example="INSTALLED")
    @NotNull
    public IntegrationState getState() {
        return IntegrationState.fromId(this.getStringProperty(STATE)).orElse(null);
    }
}

