/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

@JsonSerialize
@JsonSurrogate(value=UpstreamSettings.class)
public class RestUpstreamSettings
extends RestMapEntity {
    public static final String MODE = "mode";
    public static final String PROJECT_IDS = "projectIds";

    public RestUpstreamSettings() {
    }

    public RestUpstreamSettings(UpstreamSettings settings) {
        this.put(MODE, settings.getMode().getId());
        this.putIfNotEmpty(PROJECT_IDS, settings.getMirroredProjectIds());
    }

    public MirroringMode getMode() {
        return MirroringMode.fromId(this.getStringProperty(MODE));
    }

    @Nonnull
    public Set<String> getProjectIds() {
        Collection projectIds = (Collection)this.get(PROJECT_IDS);
        if (projectIds == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Iterable)projectIds);
    }
}

