/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestWebHookEventConverter;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.MirroringWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.webhook.MirroringWebHookEventHandler;
import com.atlassian.bitbucket.internal.mirroring.rest.RestUnknownEntity;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Hidden
@UnrestrictedAccess
@Path(value="webhookEvents")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class WebhookEventResource {
    private final InternalUpstreamService upstreamService;
    private final RestWebHookEventConverter webHookEventConverter;
    private final MirroringWebHookEventHandler webHookEventHandler;

    @Inject
    public WebhookEventResource(InternalUpstreamService upstreamService, RestWebHookEventConverter webHookEventConverter, MirroringWebHookEventHandler webHookEventHandler) {
        this.upstreamService = upstreamService;
        this.webHookEventConverter = webHookEventConverter;
        this.webHookEventHandler = webHookEventHandler;
    }

    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response onWebhookEvent(RestUnknownEntity unknown) {
        this.webHookEventConverter.convert(unknown).ifPresent(webHookEvent -> {
            InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
            this.webHookEventHandler.handleEvent(upstream.getId(), (MirroringWebHookEvent)webHookEvent);
        });
        return ResponseFactory.noContent().build();
    }
}

