/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest.server;

import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import jakarta.validation.constraints.NotBlank;
import java.util.Map;

public class RestServerExternalProject
extends RestMapEntity
implements ExternalProject {
    private static final long serialVersionUID = 4820313207371665332L;

    public RestServerExternalProject() {
    }

    public RestServerExternalProject(ExternalProject externalProject) {
        this.put("id", externalProject.getId());
        this.put("key", externalProject.getKey());
        this.put("name", externalProject.getName());
        this.put("public", externalProject.isPublic());
    }

    private RestServerExternalProject(Map<String, Object> map) {
        super(map);
    }

    @Override
    @NotBlank
    public String getId() {
        return String.valueOf(this.get("id"));
    }

    @Override
    @NotBlank
    public String getKey() {
        return this.getStringProperty("key");
    }

    @Override
    @NotBlank
    public String getName() {
        return this.getStringProperty("name");
    }

    @Override
    public boolean isPublic() {
        return this.getBoolProperty("public", false);
    }

    public static RestServerExternalProject valueOf(Object value) {
        if (value instanceof RestServerExternalProject) {
            return (RestServerExternalProject)value;
        }
        if (value instanceof Map) {
            return new RestServerExternalProject((Map)value);
        }
        if (value instanceof ExternalProject) {
            return new RestServerExternalProject((ExternalProject)value);
        }
        return null;
    }
}

