/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook;

import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.BaseRestServerWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.BaseRestWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestProjectCreatedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestProjectDeletedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestProjectModifiedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestRepositoryCreatedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestRepositoryDefaultBranchModifiedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestRepositoryDeletedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestRepositoryModifiedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestRepositoryRefsChangedWebHookEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.webhook.RestWebHookEventConverter;
import com.atlassian.bitbucket.internal.mirroring.rest.RestUnknownEntity;
import com.atlassian.bitbucket.internal.mirroring.webhook.WebHookEventId;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultRestWebHookEventConverter
implements RestWebHookEventConverter {
    private static final Logger log = LoggerFactory.getLogger(DefaultRestWebHookEventConverter.class);

    @Override
    @Nonnull
    public Optional<? extends BaseRestWebHookEvent> convert(@Nonnull RestUnknownEntity unknownEntity) {
        Objects.requireNonNull(unknownEntity, "unknownEntity");
        Optional<WebHookEventId> eventId = WebHookEventId.fromEntity(unknownEntity);
        if (!eventId.isPresent()) {
            log.debug("Unable to determine type of server web hook due to a missing key - dropping");
            return Optional.empty();
        }
        Optional<BaseRestServerWebHookEvent> event = eventId.map(id -> this.toEvent((WebHookEventId)((Object)id), unknownEntity));
        if (!event.isPresent()) {
            log.debug("Unexpected server web hook key {} - dropping web hook payload", eventId);
            return Optional.empty();
        }
        log.trace("Mapped {} to {}", (Object)eventId.get(), event.get().getClass());
        return event;
    }

    public BaseRestServerWebHookEvent toEvent(WebHookEventId eventId, RestUnknownEntity unknownEntity) {
        switch (eventId) {
            case REPOSITORY_CREATED: {
                return new RestRepositoryCreatedWebHookEvent((Map<String, ?>)((Object)unknownEntity));
            }
            case REPOSITORY_REFS_CHANGED: {
                return new RestRepositoryRefsChangedWebHookEvent((Map<String, ?>)((Object)unknownEntity));
            }
            case REPOSITORY_MODIFIED: {
                return new RestRepositoryModifiedWebHookEvent((Map<String, ?>)((Object)unknownEntity));
            }
            case REPOSITORY_DELETED: {
                return new RestRepositoryDeletedWebHookEvent((Map<String, ?>)((Object)unknownEntity));
            }
            case REPOSITORY_DEFAULT_BRANCH_MODIFIED: {
                return new RestRepositoryDefaultBranchModifiedWebHookEvent((Map<String, ?>)((Object)unknownEntity));
            }
            case PROJECT_MODIFIED: {
                return new RestProjectModifiedWebHookEvent((Map<String, ?>)((Object)unknownEntity));
            }
            case PROJECT_CREATED: {
                return new RestProjectCreatedWebHookEvent((Map<String, ?>)((Object)unknownEntity));
            }
            case PROJECT_DELETED: {
                return new RestProjectDeletedWebHookEvent((Map<String, ?>)((Object)unknownEntity));
            }
        }
        return null;
    }
}

