/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.scm.check;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.ProjectMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.scm.check.ReadOnlyMirrorPushAnalyticsEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheck;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="readOnlyRequestCheck")
public class ReadOnlyRequestCheck
implements ScmRequestCheck {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ProjectMappingDao projectMappingDao;

    @Autowired
    public ReadOnlyRequestCheck(EventPublisher eventPublisher, I18nService i18nService, ApplicationModeSupplier modeSupplier, ProjectMappingDao projectMappingDao) {
        Preconditions.checkArgument((modeSupplier.getMode() == ApplicationMode.MIRROR ? 1 : 0) != 0, (Object)"This check should only be executed in mirror mode");
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.projectMappingDao = projectMappingDao;
    }

    public boolean check(@Nonnull ScmRequest request) throws IOException {
        if (!request.isWrite()) {
            return true;
        }
        Repository repository = request.getRepository();
        this.eventPublisher.publish((Object)new ReadOnlyMirrorPushAnalyticsEvent(this, repository));
        request.sendError(this.i18nService.getMessage("bitbucket.mirroring.scm.request.readonly", new Object[0]), this.i18nService.getMessage("bitbucket.mirroring.scm.request.readonly.detail", new Object[]{this.getExternalProjectKey(repository.getProject()), repository.getSlug()}));
        return false;
    }

    private String getExternalProjectKey(Project project) {
        return this.projectMappingDao.getExternalKeyByLocalId(project.getId(), project.getKey());
    }
}

