/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.scm.check;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.ProjectMappingDao;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepositoryService;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepositoryStatus;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.ScmRequestCheck;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="repositoryMirrorNotAvailableCheck")
public class RepositoryMirrorNotAvailableCheck
implements ScmRequestCheck {
    private static final Logger log = LoggerFactory.getLogger(RepositoryMirrorNotAvailableCheck.class);
    private final I18nService i18nService;
    private final MirroredRepositoryService mirroredRepositoryService;
    private final ApplicationMode mode;
    private final ProjectMappingDao projectMappingDao;

    @Autowired
    public RepositoryMirrorNotAvailableCheck(I18nService i18nService, MirroredRepositoryService mirroredRepositoryService, ApplicationModeSupplier modeSupplier, ProjectMappingDao projectMappingDao) {
        this.i18nService = i18nService;
        this.mirroredRepositoryService = mirroredRepositoryService;
        this.mode = modeSupplier.getMode();
        this.projectMappingDao = projectMappingDao;
    }

    public boolean check(@Nonnull ScmRequest request) throws IOException {
        if (this.mode == ApplicationMode.MIRROR) {
            Repository repository = request.getRepository();
            MirroredRepositoryStatus status = this.mirroredRepositoryService.getStatus(repository);
            switch (status) {
                case AVAILABLE: {
                    return true;
                }
                case ERROR_AVAILABLE: {
                    log.warn("{}: Repository has encountered too many errors while trying to synchronize with the upstream repository. Clones and fetches may not return up-to-date content. Please resolve the problem and resynchronize with the primary.", (Object)repository);
                    return true;
                }
                case NOT_MIRRORED: {
                    request.sendError(this.i18nService.getMessage("bitbucket.mirroring.scm.request.not.available", new Object[0]), this.i18nService.getMessage("bitbucket.mirroring.scm.request.not.available.detail", new Object[0]));
                    return false;
                }
                case ERROR_INITIALIZING: {
                    log.debug("{}: The initial sync for mirrored repository has not yet completed without error. This SCM request will be rejected", (Object)repository);
                    request.sendError(this.i18nService.getMessage("bitbucket.mirroring.scm.request.not.yet.initialised.too.many.errors", new Object[0]), this.i18nService.getMessage("bitbucket.mirroring.scm.request.not.yet.initialised.too.many.errors.detail", new Object[]{this.getExternalProjectKey(repository.getProject()), repository.getSlug()}));
                    return false;
                }
                case INITIALIZING: {
                    log.debug("{}: The initial sync for mirrored repository has not completed. This SCM request will be rejected", (Object)repository);
                    request.sendError(this.i18nService.getMessage("bitbucket.mirroring.scm.request.not.yet.initialised", new Object[0]), this.i18nService.getMessage("bitbucket.mirroring.scm.request.not.yet.initialised.detail", new Object[]{this.getExternalProjectKey(repository.getProject()), repository.getSlug()}));
                    return false;
                }
            }
            log.warn("{}: Unexpected status {} for mirrored repository", (Object)status, (Object)repository);
            request.sendError(this.i18nService.getMessage("bitbucket.mirroring.scm.request.not.available", new Object[0]), this.i18nService.getMessage("bitbucket.mirroring.scm.request.not.available.detail", new Object[0]));
            return false;
        }
        return true;
    }

    private String getExternalProjectKey(Project project) {
        return this.projectMappingDao.getExternalKeyByLocalId(project.getId(), project.getKey());
    }
}

