/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.scm.http;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorPushAnalyticsEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.ModuleHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.MirrorLfsJwtAuthenticationHandler;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringNavBuilder;
import com.atlassian.bitbucket.internal.mirroring.mirror.scm.http.UnmodifiableHttpServletResponse;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmRequest;
import com.atlassian.bitbucket.scm.http.HttpRequestDetails;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import com.atlassian.bitbucket.scm.http.HttpScmRequestHandlerModuleDescriptor;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.bitbucket.util.web.ResettableHttpServletRequest;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class WriteRequestInterceptorFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WriteRequestInterceptorFilter.class);
    private final MirroringConfig config;
    private final EventPublisher eventPublisher;
    private final MirroringNavBuilder navBuilder;
    private final PluginAccessor pluginAccessor;
    private final AoProjectMappingDao projectMapper;
    private final InternalUpstreamService upstreamService;
    private final UpstreamUserHelper upstreamUserHelper;

    public WriteRequestInterceptorFilter(@Nonnull MirroringConfig config, @Nonnull EventPublisher eventPublisher, @Nonnull MirroringNavBuilder navBuilder, @Nonnull PluginAccessor pluginAccessor, @Nonnull AoProjectMappingDao projectMapper, @Nonnull InternalUpstreamService upstreamService, @Nonnull UpstreamUserHelper upstreamUserHelper) {
        this.config = config;
        this.eventPublisher = eventPublisher;
        this.navBuilder = navBuilder;
        this.pluginAccessor = pluginAccessor;
        this.projectMapper = projectMapper;
        this.upstreamService = upstreamService;
        this.upstreamUserHelper = upstreamUserHelper;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest rawRequest = (HttpServletRequest)request;
        HttpServletResponse rawResponse = (HttpServletResponse)response;
        ResettableHttpServletRequest resetRequest = this.newResettableServletRequest(rawRequest);
        UnmodifiableHttpServletResponse noopResponse = this.newUnmodifiableServletResponse(rawResponse);
        try {
            UpstreamRedirectInfo upstreamRedirectInfo = this.tryTranslateToUpstreamScmUrl((HttpServletRequest)resetRequest, noopResponse);
            if (upstreamRedirectInfo != null) {
                String upstreamWriteUrl = upstreamRedirectInfo.getRewriteUrl();
                log.debug("Redirecting SCM write request to upstream URL {}", (Object)upstreamWriteUrl);
                this.eventPublisher.publish((Object)new MirrorPushAnalyticsEvent(this, upstreamRedirectInfo.getLocalRepository()));
                rawResponse.sendRedirect(upstreamWriteUrl);
                return;
            }
        }
        catch (RuntimeException e) {
            log.error("Error while attempting to detect or handle an SCM write operation", (Throwable)e);
        }
        finally {
            resetRequest.reset();
        }
        chain.doFilter((ServletRequest)resetRequest, (ServletResponse)rawResponse);
    }

    public void init(FilterConfig filterConfig) {
    }

    @VisibleForTesting
    HttpScmRequest createScmWriteRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse, UpstreamServer upstream) {
        if (!this.isScmRequest(httpRequest)) {
            return null;
        }
        EscalatedSecurityContext serviceUserContext = this.upstreamUserHelper.asUserForUpstream(upstream.getId());
        if (serviceUserContext == null) {
            return null;
        }
        return (HttpScmRequest)serviceUserContext.call(() -> ModuleHelper.getSortedModules(this.pluginAccessor, HttpScmRequestHandlerModuleDescriptor.class).filter(handler -> handler.supports(HttpRequestDetails.ofServletRequest((HttpServletRequest)httpRequest))).map(handler -> handler.create(httpRequest, httpResponse)).filter(handler -> handler.map(ScmRequest::isWrite).orElse(false)).map(Optional::get).findFirst().orElse(null));
    }

    @VisibleForTesting
    boolean isScmRequest(HttpServletRequest httpRequest) {
        return "/scm".equalsIgnoreCase(httpRequest.getServletPath()) && !MirrorLfsJwtAuthenticationHandler.LFS_BATCH_URL_PATTERN.matcher(httpRequest.getPathInfo()).matches();
    }

    @VisibleForTesting
    ResettableHttpServletRequest newResettableServletRequest(HttpServletRequest request) {
        return new ResettableHttpServletRequest(request);
    }

    @VisibleForTesting
    UnmodifiableHttpServletResponse newUnmodifiableServletResponse(HttpServletResponse response) {
        return new UnmodifiableHttpServletResponse(response);
    }

    @VisibleForTesting
    String translateToUpstreamScmUrl(@Nonnull UpstreamServer upstream, @Nonnull String externalProjectKey, @Nonnull String externalRepoSlug, @Nullable String pathSuffix, @Nullable String queryString) {
        String[] pathSuffixSegments = StringUtils.isEmpty((CharSequence)pathSuffix) ? new String[]{} : pathSuffix.split("/");
        Multimap<String, Object> parameters = this.toMultimap(UrlUtils.splitQuery((String)StringUtils.trimToEmpty((String)queryString)));
        return this.navBuilder.upstream(upstream).repositoryScmOverHttps(externalProjectKey.toLowerCase(Locale.ROOT), externalRepoSlug).path(pathSuffixSegments).parameters(parameters).getAbsolute();
    }

    private boolean isSupportedByUserAgent(HttpServletRequest httpRequest) {
        return !StringUtils.startsWithIgnoreCase((CharSequence)httpRequest.getHeader("user-agent"), (CharSequence)"JGit/");
    }

    private boolean isUrlValid(RepositoryUrlFragment url, Repository repo, String pathInfo) {
        if (!repo.getSlug().equalsIgnoreCase(url.getRepositorySlug()) || !repo.getProject().getKey().equalsIgnoreCase(url.getProjectKey())) {
            log.debug("The request path structure for '{}' is not what we infer it should be (repo is {}, we inferred {})", new Object[]{pathInfo, repo, url});
            return false;
        }
        return true;
    }

    private Multimap<String, Object> toMultimap(@Nonnull Map<String, List<Object>> queryParams) {
        ArrayListMultimap queryParamsMmap = ArrayListMultimap.create();
        queryParams.forEach((arg_0, arg_1) -> ((Multimap)queryParamsMmap).putAll(arg_0, arg_1));
        return queryParamsMmap;
    }

    private UpstreamRedirectInfo tryTranslateToUpstreamScmUrl(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String externalRepoSlug;
        String externalProjectKey;
        InternalUpstreamServer upstream = this.upstreamService.get();
        if (upstream == null || upstream.getState() != IntegrationState.INSTALLED && upstream.getState() != IntegrationState.UNKNOWN || !this.config.isHttpWriteEnabled()) {
            return null;
        }
        if (!this.isSupportedByUserAgent(httpRequest)) {
            return null;
        }
        HttpScmRequest scmWriteRequest = this.createScmWriteRequest(httpRequest, httpResponse, upstream);
        if (scmWriteRequest == null) {
            return null;
        }
        Repository repo = scmWriteRequest.getRepository();
        log.trace("This is a SCM write request for {}", (Object)repo);
        String pathInfo = httpRequest.getPathInfo();
        RepositoryUrlFragment repoUrl = RepositoryUrlFragment.fromPathInfo((String)pathInfo);
        if (repoUrl == null) {
            log.info("Unable to parse the request path '{}' to determine the URL upstream to redirect to - unable to redirect to the upstream server", (Object)pathInfo);
            return null;
        }
        if (!(this.isUrlValid(repoUrl, repo, pathInfo) || (repoUrl = RepositoryUrlFragment.fromNamespacedPathInfo((String)pathInfo)) != null && this.isUrlValid(repoUrl, repo, pathInfo))) {
            log.info("Request URL is invalid - unable to redirect to upstream server");
            return null;
        }
        AoProjectMapping projectMapping = this.projectMapper.getByLocalId(repo.getProject().getId());
        if (projectMapping != null) {
            externalProjectKey = projectMapping.getExternalKey();
            externalRepoSlug = repo.getSlug();
        } else {
            externalProjectKey = repo.getProject().getKey();
            externalRepoSlug = repo.getSlug();
            log.debug("{}: Unable to map repository's project to the external project on the upstream", (Object)repo);
        }
        String rewriteUrl = this.translateToUpstreamScmUrl(upstream, externalProjectKey, externalRepoSlug, repoUrl.getPathSuffix(), httpRequest.getQueryString());
        return new UpstreamRedirectInfo(rewriteUrl, repo);
    }

    private static class UpstreamRedirectInfo {
        private final Repository localRepository;
        private final String rewriteUrl;

        private UpstreamRedirectInfo(@Nonnull String rewriteUrl, @Nonnull Repository localRepository) {
            this.rewriteUrl = rewriteUrl;
            this.localRepository = localRepository;
        }

        @Nonnull
        public Repository getLocalRepository() {
            return this.localRepository;
        }

        @Nonnull
        public String getRewriteUrl() {
            return this.rewriteUrl;
        }
    }
}

