/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.ssh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.MirrorKeyPairGenerator;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.MirrorKeyStorageException;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.SshKeyStore;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.SshUtils;
import com.atlassian.bitbucket.internal.mirroring.ssh.encoding.KeyCodecException;
import com.atlassian.bitbucket.internal.mirroring.ssh.encoding.PrivateKeyPemHelper;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.bitbucket.util.MoreFiles;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="sshKeyStore")
@NotThreadSafe
public class DefaultSshKeyStore
implements SshKeyStore {
    private static final Logger log = LoggerFactory.getLogger(DefaultSshKeyStore.class);
    private final I18nService i18nService;
    private final JcaPEMKeyConverter jcaPEMKeyConverter;
    private final MirrorKeyPairGenerator keyPairGenerator;
    private final PrivateKeyPemHelper privateKeyPemHelper;
    private final StorageService storageService;

    @Autowired
    public DefaultSshKeyStore(I18nService i18nService, MirrorKeyPairGenerator keyPairGenerator, PrivateKeyPemHelper privateKeyPemHelper, StorageService storageService) {
        this.i18nService = i18nService;
        this.keyPairGenerator = keyPairGenerator;
        this.privateKeyPemHelper = privateKeyPemHelper;
        this.storageService = storageService;
        this.jcaPEMKeyConverter = new JcaPEMKeyConverter();
        this.jcaPEMKeyConverter.setProvider("BC");
    }

    @Override
    public boolean delete(@Nonnull String keyId) {
        Path file = this.getPrivateKeyFile(this.sanitizeKeyId(keyId));
        try {
            Files.delete(file);
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException e) {
            MoreFiles.deleteOnExit((Path)file);
        }
        return false;
    }

    @Override
    @Nonnull
    public Pair<Path, KeyPair> generateKeyPair(@Nonnull String keyId) {
        KeyPair keyPair = this.keyPairGenerator.generate();
        Path privateKeyFile = this.savePrivateKey(this.sanitizeKeyId(keyId), keyPair.getPrivate());
        return Pair.pair((Object)privateKeyFile, (Object)keyPair);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public Optional<KeyPair> getKeyPair(@Nonnull String keyId) {
        try (BufferedReader reader = Files.newBufferedReader(this.getPrivateKeyFile(keyId));){
            PEMParser parser;
            block16: {
                Optional<KeyPair> optional;
                parser = new PEMParser((Reader)reader);
                try {
                    Object object = parser.readObject();
                    if (!(object instanceof PEMKeyPair)) break block16;
                    optional = Optional.of(this.jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object));
                }
                catch (Throwable throwable) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                parser.close();
                return optional;
            }
            Optional<KeyPair> optional = Optional.empty();
            parser.close();
            return optional;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return Optional.empty();
        }
        catch (IOException e) {
            log.warn("Error loading key file {}", (Object)keyId, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    @Nonnull
    public Optional<Path> getPrivateKey(@Nonnull String keyId) {
        return Optional.of(this.getPrivateKeyFile(this.sanitizeKeyId(keyId))).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    @Override
    public void update(@Nonnull String keyId, @Nonnull PrivateKey privateKey) {
        this.savePrivateKey(keyId, privateKey);
    }

    private Path getKeyDir() {
        return this.storageService.getConfigDir().resolve(".ssh");
    }

    private Path getPrivateKeyFile(@Nonnull String keyId) {
        return this.getKeyDir().resolve(keyId);
    }

    private Path maybeCreateKey(Path keyDir, String keyName) throws IOException {
        Path sshFile = keyDir.resolve(keyName);
        if (!Files.exists(sshFile, new LinkOption[0])) {
            Files.createFile(sshFile, new FileAttribute[0]);
            if (log.isDebugEnabled()) {
                log.debug("Created {}: [read={}, write={}, execute={}]", new Object[]{sshFile, Files.isReadable(sshFile), Files.isWritable(sshFile), Files.isExecutable(sshFile)});
            }
        } else if (log.isTraceEnabled()) {
            log.trace("{} already exists: [read={}, write={}, execute={}]", new Object[]{sshFile, Files.isReadable(sshFile), Files.isWritable(sshFile), Files.isExecutable(sshFile)});
        }
        return sshFile;
    }

    private Path maybeCreateKeyDir() throws IOException {
        Path sshDir = this.getKeyDir();
        if (!Files.exists(sshDir, new LinkOption[0])) {
            Files.createDirectories(sshDir, new FileAttribute[0]);
            SshUtils.secureSshResourceForOwner(sshDir);
            if (log.isDebugEnabled()) {
                log.debug("Created {}: [read={}, write={}, execute={}]", new Object[]{sshDir, Files.isReadable(sshDir), Files.isWritable(sshDir), Files.isExecutable(sshDir)});
            }
        } else if (log.isTraceEnabled()) {
            log.trace("{} already exists: [read={}, write={}, execute={}]", new Object[]{sshDir, Files.isReadable(sshDir), Files.isWritable(sshDir), Files.isExecutable(sshDir)});
        }
        return sshDir;
    }

    private String sanitizeKeyId(String keyId) {
        return keyId.replaceAll("(\\.\\.)|[\\\\/]", "_");
    }

    private Path savePrivateKey(@Nonnull String keyId, @Nonnull PrivateKey privateKey) {
        Objects.requireNonNull(privateKey, "privateKey");
        Objects.requireNonNull(keyId, "keyId");
        try {
            Path privateKeyFile = this.maybeCreateKey(this.maybeCreateKeyDir(), keyId);
            this.privateKeyPemHelper.write(privateKey, privateKeyFile);
            SshUtils.secureSshResourceForOwner(privateKeyFile);
            return privateKeyFile;
        }
        catch (KeyCodecException | IOException e) {
            throw new MirrorKeyStorageException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.store.ssh.error", new Object[]{keyId, e}), e);
        }
    }
}

