/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.ssh;

import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClientFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.UpstreamSshSettingService;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.UpstreamSshSettings;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class DefaultUpstreamSshSettingService
implements UpstreamSshSettingService {
    private final LoadingCache<String, UpstreamSshSettings> sshSettingsCache;

    public DefaultUpstreamSshSettingService(@Nonnull ApplicationPropertiesService applicationPropertiesService, @Nonnull ExecutorService executorService, final @Nonnull InternalUpstreamClientFactory upstreamClientFactory, final @Nonnull InternalUpstreamService upstreamService) {
        final ListeningExecutorService listeningExecutorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
        long ttl = applicationPropertiesService.getPluginProperty("plugin.mirroring.ssh.proxy.upstream.settings.cache.ttl", 5L);
        this.sshSettingsCache = CacheBuilder.newBuilder().refreshAfterWrite(ttl, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, UpstreamSshSettings>(this){

            public UpstreamSshSettings load(@Nonnull String ignored) {
                return this.getSshSettings();
            }

            public ListenableFuture<UpstreamSshSettings> reload(@Nonnull String ignored, @Nonnull UpstreamSshSettings prevSettings) {
                return listeningExecutorService.submit(this::getSshSettings);
            }

            @Nonnull
            private UpstreamSshSettings getSshSettings() {
                return upstreamClientFactory.create(upstreamService.getUpstreamOrFail()).getSshSettings();
            }
        });
    }

    @Override
    @Nonnull
    public UpstreamSshSettings getSshSettings() {
        return (UpstreamSshSettings)this.sshSettingsCache.getUnchecked((Object)"ignored");
    }
}

