/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.ssh;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

class ProxiedCommand {
    private final String[] parts;
    private final Repository repository;

    public ProxiedCommand(@Nonnull String[] commandParts, @Nullable Repository repository) {
        this.parts = Objects.requireNonNull(commandParts, "commandParts");
        Preconditions.checkArgument((commandParts.length > 0 ? 1 : 0) != 0, (Object)"commandParts length must be greater than 0");
        Objects.requireNonNull(commandParts[0]);
        this.repository = repository;
    }

    @Nonnull
    public String getFirstPart() {
        return this.parts[0];
    }

    @Nullable
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public String toCommand() {
        return String.join((CharSequence)" ", this.parts);
    }

    @Nonnull
    public String toProxyCommand(@Nonnull ApplicationUser forUser) {
        return String.format("proxy %d %s", forUser.getId(), this.toCommand());
    }
}

