/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.ssh;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.ssh.DmzPublicKeyCodec;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.mirroring.MirroringConstants;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.SyncCredentials;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.SyncCredentialsManager;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.ProjectMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.ProxiedCommand;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.UpstreamSshSettingService;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.UpstreamSshSettings;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.bitbucket.ssh.SimpleSshKeyFingerprint;
import com.atlassian.bitbucket.ssh.SshKeyFingerprint;
import com.atlassian.bitbucket.ssh.command.SshCommand;
import com.atlassian.bitbucket.ssh.command.SshCommandContext;
import com.atlassian.bitbucket.ssh.command.SshCommandFactory;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URI;
import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Duration;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySshCommandFactory
implements SshCommandFactory {
    private static final Logger log = LoggerFactory.getLogger(ProxySshCommandFactory.class);
    private static final Pattern QUOTED_REPO = Pattern.compile("'([^']+)'");
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final MirroringConfig mirroringConfig;
    private final ProjectMappingDao projectMappingDao;
    private final DmzPublicKeyCodec publicKeyCodec;
    private final RepositoryService repositoryService;
    private final ClientBuilder sshClientBuilder;
    private final SyncCredentialsManager syncCredentialsManager;
    private final UpstreamSshSettingService upstreamSshSettingService;
    private final InternalUpstreamService upstreamService;

    public ProxySshCommandFactory(@Nonnull AuthenticationContext authenticationContext, @Nonnull EventPublisher eventPublisher, @Nonnull I18nService i18nService, @Nonnull MirroringConfig mirroringConfig, @Nonnull ProjectMappingDao projectMappingDao, @Nonnull DmzPublicKeyCodec publicKeyCodec, @Nonnull RepositoryService repositoryService, @Nonnull ClientBuilder sshClientBuilder, @Nonnull SyncCredentialsManager syncCredentialsManager, @Nonnull UpstreamSshSettingService upstreamSshSettingService, @Nonnull InternalUpstreamService upstreamService) {
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.mirroringConfig = mirroringConfig;
        this.projectMappingDao = projectMappingDao;
        this.publicKeyCodec = publicKeyCodec;
        this.repositoryService = repositoryService;
        this.sshClientBuilder = sshClientBuilder;
        this.syncCredentialsManager = syncCredentialsManager;
        this.upstreamSshSettingService = upstreamSshSettingService;
        this.upstreamService = upstreamService;
    }

    @Nonnull
    public Optional<SshCommand> create(@Nonnull SshCommandContext context) {
        if (!this.supports(context.getCommand())) {
            return Optional.empty();
        }
        return Optional.of(new ProxySshCommand(context, this.authenticationContext.getCurrentUser(), this.upstreamService.getUpstreamOrFail()));
    }

    public boolean supports(@Nonnull String command) {
        InternalUpstreamServer upstreamServer = this.upstreamService.getUpstreamOrFail();
        return this.mirroringConfig.isSshProxyEnabled() && this.isSupportedSshProxyCommand(command) && this.isCurrentUsersAuthDelegated() && this.isUpstreamSshStateKnownAndEnabled(upstreamServer);
    }

    private boolean isCurrentUsersAuthDelegated() {
        return this.authenticationContext.getCurrentUser() instanceof ApplicationUserWithPermissions;
    }

    private boolean isLfsDownloadCommand(String proxiedCommand) {
        return proxiedCommand.startsWith("git-lfs-authenticate") && proxiedCommand.endsWith("download");
    }

    private boolean isSupportedSshProxyCommand(@Nonnull String proxiedCommand) {
        String[] proxiedCommandParts = proxiedCommand.toLowerCase(Locale.ROOT).split("\\s+");
        if (proxiedCommandParts.length > 0) {
            if (MirroringConstants.SUPPORTED_SSH_PROXY_COMMANDS.stream().anyMatch(proxiedCommandParts[0]::equals)) {
                if (this.isLfsDownloadCommand(proxiedCommand)) {
                    return this.mirroringConfig.getLfsDownloadFromUpstream();
                }
                return true;
            }
        }
        return false;
    }

    private boolean isUpstreamSshStateKnownAndEnabled(UpstreamServer upstreamServer) {
        boolean enabled = this.upstreamSshSettingService.getSshSettings().isEnabled();
        if (!enabled) {
            log.debug("The upstream server {} has disabled SSH which is required to proxy this command. Please consult your administrator to enable this", MirrorDescriptionUtils.describe(upstreamServer));
        }
        return enabled;
    }

    private class ProxySshCommand
    implements SshCommand {
        private static final int FAILURE_CODE = -1;
        private final String command;
        private final SshCommandContext context;
        private final ApplicationUser currentUser;
        private final UpstreamServer upstreamServer;
        private volatile ChannelExec channel;

        ProxySshCommand(@Nonnull SshCommandContext context, @Nonnull ApplicationUser currentUser, UpstreamServer upstreamServer) {
            this.context = context;
            this.currentUser = currentUser;
            this.upstreamServer = upstreamServer;
            this.command = context.getCommand();
        }

        public void cancel() {
            ChannelExec channel = this.channel;
            if (channel != null) {
                log.debug("Cancelling command \"{}\" executing on upstream {} for user {}", new Object[]{this.command, MirrorDescriptionUtils.describe(this.upstreamServer), this.currentUser.getId()});
                channel.close(true);
                this.channel = null;
            } else {
                log.trace("Command \"{}\" was either not yet started or has already finished executing on upstream {} for user {}", new Object[]{this.command, MirrorDescriptionUtils.describe(this.upstreamServer), this.currentUser.getId()});
            }
        }

        /*
         * Exception decompiling
         */
        public int run() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean isRepoWriteCommand(ProxiedCommand proxiedCommand) {
            return MirroringConstants.SUPPORTED_SSH_PROXY_SCM_WRITE_COMMANDS.contains(proxiedCommand.getFirstPart()) && proxiedCommand.getRepository() != null && !ProxySshCommandFactory.this.isLfsDownloadCommand(proxiedCommand.toCommand());
        }

        private SshClient buildSshClient(SyncCredentials upstreamCredentials, UpstreamSshSettings upstreamSshSettings) {
            try {
                SshClient sshClient = (SshClient)ProxySshCommandFactory.this.sshClientBuilder.build();
                KeyPair keyPair = ClientIdentityLoader.DEFAULT.loadClientIdentities(null, () -> upstreamCredentials.getKeyFile().toAbsolutePath().toString(), FilePasswordProvider.EMPTY).iterator().next();
                sshClient.addPublicKeyIdentity(keyPair);
                if (!ProxySshCommandFactory.this.mirroringConfig.isSshProxyConfigParsed()) {
                    sshClient.setHostConfigEntryResolver(HostConfigEntryResolver.EMPTY);
                }
                sshClient.setServerKeyVerifier((clientSession, remoteAddress, serverKey) -> this.isMatchingFingerprint(upstreamSshSettings.getFingerprint(), serverKey));
                Duration idleTimeout = ProxySshCommandFactory.this.mirroringConfig.getSshProxyUpstreamIdleTimeout();
                PropertyResolverUtils.updateProperty((PropertyResolver)sshClient, CoreModuleProperties.IDLE_TIMEOUT.getName(), idleTimeout.toMillis());
                sshClient.start();
                return sshClient;
            }
            catch (Exception e) {
                log.error("Exception encountered constructing an SSH client for proxying SSH commands to upstream server {}. The proxied command will be rejected", MirrorDescriptionUtils.describe(this.upstreamServer), (Object)e);
                return null;
            }
        }

        @Nullable
        private ClientSession buildSshSession(SshClient sshClient, UpstreamSshSettings upstreamSshSettings, UpstreamServer upstreamServer) throws SshException {
            if (sshClient == null || upstreamSshSettings == null) {
                return null;
            }
            ClientSession session = null;
            try {
                session = this.connectSshSession(sshClient, upstreamSshSettings.getBaseUrl());
                Duration authTimeout = ProxySshCommandFactory.this.mirroringConfig.getSshProxyUpstreamAuthTimeout();
                session.auth().verify(authTimeout.toMillis(), CancelOption.CANCEL_ON_INTERRUPT, CancelOption.CANCEL_ON_TIMEOUT);
                return session;
            }
            catch (Exception e) {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.isAuthenticationException(e)) {
                    throw (SshException)e;
                }
                log.error("Failure connecting and authenticating with the upstream {} via SSH. The proxied command will be rejected", MirrorDescriptionUtils.describe(upstreamServer), (Object)e);
                return null;
            }
        }

        private ClientSession connectSshSession(SshClient sshClient, String baseUrl) throws IOException {
            try {
                URI baseUri = URI.create(baseUrl);
                String host = baseUri.getHost();
                int port = baseUri.getPort() == -1 ? 22 : baseUri.getPort();
                Duration connectionTimeout = ProxySshCommandFactory.this.mirroringConfig.getSshProxyUpstreamConnectionTimeout();
                if (host.contains("[") && host.contains("]")) {
                    host = host.replace("[", "").replace("]", "");
                }
                return (ClientSession)((ConnectFuture)sshClient.connect("git", host, port).verify(connectionTimeout.toMillis())).getSession();
            }
            catch (Exception e) {
                log.error("Error connecting via SSH to upstream server {}. The proxied command will be rejected", MirrorDescriptionUtils.describe(this.upstreamServer), (Object)e);
                throw e;
            }
        }

        private SyncCredentials getOrRegisterUpstreamSshCreds() {
            try {
                return (SyncCredentials)ProxySshCommandFactory.this.syncCredentialsManager.getCredentials(this.upstreamServer.getId()).claim();
            }
            catch (RuntimeException e) {
                log.warn("Could not find valid local SSH credentials for upstream server {} and registration of new credentials failed. This SSH push command {} will not be proxied to the upstream and will be rejected", new Object[]{MirrorDescriptionUtils.describe(this.upstreamServer), this.command, e});
                return null;
            }
        }

        private boolean isAuthenticationException(Exception e) {
            String message = e.getMessage();
            return e instanceof SshException && message != null && message.contains("authentication");
        }

        private SyncCredentials refreshSshCreds(SyncCredentials credentials) {
            try {
                return (SyncCredentials)ProxySshCommandFactory.this.syncCredentialsManager.refresh(credentials).claim();
            }
            catch (RuntimeException e) {
                log.warn("Failed to refresh SSH credentials with upstream server {}. This SSH push command {} will not be proxied to the upstream and will be rejected", new Object[]{MirrorDescriptionUtils.describe(this.upstreamServer), this.command, e});
                return null;
            }
        }

        private ProxiedCommand translateToProxiedCommand(String command) {
            String[] commandParts = command.trim().split("\\s+");
            Repository repository = null;
            if (commandParts.length > 1) {
                AoProjectMapping projectMapping;
                Matcher quoted = QUOTED_REPO.matcher(commandParts[1]);
                String maybeRepositoryReference = quoted.matches() ? quoted.group(1) : commandParts[1];
                RepositoryUrlFragment repoFragment = RepositoryUrlFragment.fromPathInfo((String)maybeRepositoryReference);
                if (repoFragment == null) {
                    log.debug("Unable to determine repository from reference \"{}\"", (Object)maybeRepositoryReference);
                    throw this.throwInvalidRepositoryUrl(commandParts[1]);
                }
                repository = this.getRepositoryFromUrl(repoFragment);
                if (repository == null) {
                    repoFragment = RepositoryUrlFragment.fromNamespacedPathInfo((String)maybeRepositoryReference);
                    if (repoFragment == null) {
                        throw this.throwNoSuchRepository();
                    }
                    repository = this.getRepositoryFromUrl(repoFragment);
                    if (repository == null) {
                        log.debug("Repository for reference {} not found", (Object)repoFragment);
                        throw this.throwNoSuchRepository();
                    }
                }
                if ((projectMapping = ProxySshCommandFactory.this.projectMappingDao.getByLocalId(repository.getProject().getId())) == null) {
                    log.debug("{}: No upstream project mapping found", (Object)repository.getProject());
                    throw this.throwNoSuchRepository();
                }
                String pathTemplate = "'/%s/%s'";
                if (command.startsWith("git-lfs-")) {
                    pathTemplate = "%s/%s";
                }
                commandParts[1] = String.format(pathTemplate, projectMapping.getExternalKey(), repository.getSlug());
            }
            return new ProxiedCommand(commandParts, repository);
        }

        private Repository getRepositoryFromUrl(RepositoryUrlFragment repoFragment) {
            try {
                return ProxySshCommandFactory.this.repositoryService.getBySlug(repoFragment.getProjectKey(), repoFragment.getRepositorySlug());
            }
            catch (RepositoryMovedException e) {
                return e.getRepository();
            }
            catch (AuthorisationException e) {
                log.debug("Repository for reference {} found but current user is not authorised to read it", (Object)repoFragment);
                throw e;
            }
        }

        private boolean isMatchingFingerprint(SshKeyFingerprint expectedFingerprint, PublicKey serverKey) {
            SimpleSshKeyFingerprint serverFingerprint = new SimpleSshKeyFingerprint(serverKey.getAlgorithm(), ProxySshCommandFactory.this.publicKeyCodec.calculateFingerprint(serverKey));
            if (serverFingerprint.equals((Object)expectedFingerprint)) {
                log.trace("Upstream SSH fingerprint matches what was expected: {}", (Object)serverFingerprint);
                return true;
            }
            log.warn("The SSH fingerprint of upstream server {} does not match what was expected. Expected: {}, was: {}. This proxy command will be rejected", new Object[]{MirrorDescriptionUtils.describe(this.upstreamServer), expectedFingerprint, serverFingerprint});
            return false;
        }

        private ChannelExec execute(ClientSession session, String proxyCommand) throws IOException {
            Duration channelTimeout = ProxySshCommandFactory.this.mirroringConfig.getSshProxyUpstreamChannelTimeout();
            Duration executionTimeout = ProxySshCommandFactory.this.mirroringConfig.getSshProxyUpstreamExecutionTimeout();
            ChannelExec channel = session.createExecChannel(proxyCommand);
            channel.setIn(this.context.getStdin());
            channel.setOut(this.context.getStdout());
            channel.setErr(this.context.getStderr());
            this.context.getEnvironment().forEach(channel::setEnv);
            channel.open().verify(channelTimeout.toMillis(), CancelOption.CANCEL_ON_INTERRUPT, CancelOption.CANCEL_ON_TIMEOUT);
            channel.waitFor((Collection<ClientChannelEvent>)Sets.immutableEnumSet((Enum)ClientChannelEvent.CLOSED, (Enum[])new ClientChannelEvent[0]), executionTimeout.toMillis());
            return channel;
        }

        private NoSuchRepositoryException throwInvalidRepositoryUrl(@Nonnull String repositoryFragment) {
            KeyedMessage message = ProxySshCommandFactory.this.i18nService.createKeyedMessage("bitbucket.mirroring.scm.request.ssh.url.invalid.message", new Object[]{Product.NAME, repositoryFragment});
            throw new NoSuchRepositoryException(message, null);
        }

        private NoSuchRepositoryException throwNoSuchRepository() {
            KeyedMessage message = ProxySshCommandFactory.this.i18nService.createKeyedMessage("bitbucket.mirroring.scm.request.not.available.detail", new Object[0]);
            throw new NoSuchRepositoryException(message, null);
        }
    }
}

