/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.ssh;

import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.UpstreamSshSettings;
import com.atlassian.bitbucket.ssh.SshKeyFingerprint;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class SimpleUpstreamSshSettings
implements UpstreamSshSettings {
    private final boolean accessKeysEnabled;
    private final String baseUrl;
    private final boolean enabled;
    private final SshKeyFingerprint fingerprint;
    private final int port;

    public SimpleUpstreamSshSettings(boolean accessKeysEnabled, boolean enabled, @Nonnull SshKeyFingerprint fingerprint, int port, @Nonnull String baseUrl) {
        this.accessKeysEnabled = accessKeysEnabled;
        this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl");
        this.enabled = enabled;
        this.fingerprint = Objects.requireNonNull(fingerprint, "fingerprint");
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleUpstreamSshSettings that = (SimpleUpstreamSshSettings)o;
        return this.accessKeysEnabled == that.accessKeysEnabled && this.enabled == that.enabled && this.port == that.port && Objects.equals(this.fingerprint, that.fingerprint) && Objects.equals(this.baseUrl, that.baseUrl);
    }

    @Override
    public boolean isAccessKeysEnabled() {
        return this.accessKeysEnabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Nonnull
    public SshKeyFingerprint getFingerprint() {
        return this.fingerprint;
    }

    public int hashCode() {
        return Objects.hash(this.accessKeysEnabled, this.baseUrl, this.enabled, this.fingerprint, this.port);
    }
}

