/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.ssh;

import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshUtils {
    private static final Logger log = LoggerFactory.getLogger(SshUtils.class);

    @Nonnull
    public static KeyPair generateStandardRSAKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            return keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            log.warn("Failed to generate RSA KeyPair", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void secureSshResourceForOwner(@Nonnull Path path) {
        File fileOrDir = path.toFile();
        fileOrDir.setReadable(false, false);
        fileOrDir.setWritable(false, false);
        fileOrDir.setExecutable(false, false);
        fileOrDir.setReadable(true, true);
        fileOrDir.setWritable(true, true);
        if (fileOrDir.isDirectory()) {
            fileOrDir.setExecutable(true, true);
        }
    }

    @Nonnull
    public static String toStub(@Nonnull String key) {
        String[] keyArr = key.split(" ");
        if (keyArr.length < 2) {
            throw new IllegalArgumentException("Key is not an OpenSSH key.");
        }
        return keyArr[1].substring(0, Math.min(8, keyArr[1].length())) + "...";
    }
}

