/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;

public class DedupingExecutor {
    private final ExecutorService delegate;
    private final ConcurrentMap<Object, Optional<FutureTask<?>>> submittedWhileExecuting;

    public DedupingExecutor(ExecutorService delegate) {
        this.delegate = delegate;
        this.submittedWhileExecuting = new ConcurrentHashMap();
    }

    public Future<?> submit(@Nonnull Object taskId, Runnable task) {
        Optional next = this.submittedWhileExecuting.merge(taskId, Optional.empty(), (oldValue, newValue) -> {
            if (oldValue.isPresent()) {
                return oldValue;
            }
            return Optional.of(this.resubmittingTask(taskId, task));
        });
        if (next.isPresent()) {
            return (Future)next.get();
        }
        try {
            return this.delegate.submit(this.resubmittingTask(taskId, task));
        }
        catch (RejectedExecutionException e) {
            this.submittedWhileExecuting.remove(taskId);
            throw e;
        }
    }

    private FutureTask<?> resubmittingTask(Object taskId, Runnable task) {
        ListenableFutureTask futureTask = ListenableFutureTask.create((Runnable)task, null);
        futureTask.addListener((Runnable)new MaybeSubmitNextTask(taskId), MoreExecutors.directExecutor());
        return futureTask;
    }

    private class MaybeSubmitNextTask
    implements Runnable {
        private final Object taskId;

        private MaybeSubmitNextTask(Object taskId) {
            this.taskId = taskId;
        }

        @Override
        public void run() {
            Optional nextTask;
            do {
                if ((nextTask = (Optional)DedupingExecutor.this.submittedWhileExecuting.get(this.taskId)) == null) {
                    return;
                }
                if (nextTask.isPresent() || !DedupingExecutor.this.submittedWhileExecuting.remove(this.taskId, nextTask)) continue;
                return;
            } while (!DedupingExecutor.this.submittedWhileExecuting.replace(this.taskId, nextTask, Optional.empty()));
            try {
                DedupingExecutor.this.delegate.submit((Runnable)nextTask.get());
                return;
            }
            catch (RejectedExecutionException e) {
                DedupingExecutor.this.submittedWhileExecuting.remove(this.taskId);
                throw e;
            }
        }
    }
}

