/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DedupingScheduledExecutor {
    private static final Logger log = LoggerFactory.getLogger(DedupingScheduledExecutor.class);
    private final ScheduledExecutorService delegate;
    private final Map<Object, ScheduledFuture<?>> scheduledToExecute;

    public DedupingScheduledExecutor(@Nonnull ScheduledExecutorService delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.scheduledToExecute = new ConcurrentHashMap();
    }

    public ScheduledFuture<?> schedule(@Nonnull Object taskId, @Nonnull Runnable task, long delay, @Nonnull TimeUnit unit) {
        Objects.requireNonNull(taskId, "taskId");
        Objects.requireNonNull(task, "task");
        Objects.requireNonNull(unit, "unit");
        return this.scheduledToExecute.computeIfAbsent(taskId, key -> this.delegate.schedule(() -> {
            this.scheduledToExecute.remove(key);
            log.debug("Executing task {}", taskId);
            task.run();
        }, delay, unit));
    }
}

