/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.internal.mirroring.mirror.sync.ExternalMappingHelper;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectMovedException;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.security.random.SecureTokenGenerator;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.text.Normalizer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultExternalMappingHelper
implements ExternalMappingHelper {
    private static final int MAX_RETRY_COUNT = 10;
    private static final Pattern REPO_SLUG_VALID = Pattern.compile("[\\p{Alnum}][\\w\\-\\.]*");
    private static final Pattern PROJECT_KEY_VALID = Pattern.compile("~[a-zA-Z0-9\\-_.]+|[a-zA-Z][a-zA-Z0-9_\\-]*");
    private static final Pattern PROJECT_NAME_VALID = Pattern.compile("^[^~].*");
    private static final Pattern PROJECT_NAME_REMOVE = Pattern.compile("^~*");
    private final RepositoryService repositoryService;
    private final SecureTokenGenerator tokenGenerator;
    private final ProjectService projectService;

    public DefaultExternalMappingHelper(ProjectService projectService, RepositoryService repositoryService, SecureTokenGenerator tokenGenerator) {
        this.repositoryService = repositoryService;
        this.tokenGenerator = tokenGenerator;
        this.projectService = projectService;
    }

    @Override
    @Nonnull
    public String getUniqueProjectKey(@Nonnull String externalKey, @Nullable Project currentProject) {
        String randomKey;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)externalKey), (Object)"externalKey is empty");
        String key = this.escapeProjectKey(externalKey);
        if (this.canUseProjectKey(key, currentProject)) {
            return key;
        }
        for (int i = 0; i < 10; ++i) {
            String numberKey = this.appendNumber(key, i + 1, 128);
            if (!this.canUseProjectKey(numberKey, currentProject)) continue;
            return numberKey;
        }
        while (!this.canUseProjectKey(randomKey = this.generateRandomString(128), currentProject)) {
        }
        return randomKey;
    }

    @Override
    public String getUniqueProjectName(@Nonnull String externalName, @Nullable Project currentProject) {
        String randomName;
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)externalName), (Object)"externalName is empty");
        String name = this.escapeProjectName(externalName);
        if (this.canUseProjectName(name, currentProject)) {
            return name;
        }
        for (int i = 0; i < 10; ++i) {
            String numberName = this.appendNumber(name, i + 1, 128);
            if (!this.canUseProjectName(numberName, currentProject)) continue;
            return numberName;
        }
        while (!this.canUseProjectName(randomName = this.generateRandomString(128), currentProject)) {
        }
        return randomName;
    }

    private String appendNumber(String prefix, int number, int maxLength) {
        String postfix = String.format("-%02d", number);
        int computedLength = postfix.length() + prefix.length();
        if (computedLength > maxLength) {
            prefix = prefix.substring(0, prefix.length() - (computedLength - maxLength));
        }
        return prefix + postfix;
    }

    private boolean canUseProjectKey(String key, Project currentOwner) {
        Project project;
        if (!PROJECT_KEY_VALID.matcher(key).matches()) {
            return false;
        }
        try {
            project = this.projectService.getByKey(key);
        }
        catch (ProjectMovedException e) {
            project = null;
        }
        return project == null || currentOwner != null && currentOwner.getId() == project.getId();
    }

    private boolean canUseProjectName(String name, Project currentOwner) {
        if (!PROJECT_NAME_VALID.matcher(name).matches()) {
            return false;
        }
        Project project = this.projectService.getByName(name);
        return project == null || currentOwner != null && currentOwner.getId() == project.getId();
    }

    private boolean canUseRepoSlug(Project project, String slug, Repository currentOwner) {
        Repository existingRepo;
        if (!REPO_SLUG_VALID.matcher(slug).matches()) {
            return false;
        }
        try {
            existingRepo = this.repositoryService.getBySlug(project.getKey(), slug);
        }
        catch (RepositoryMovedException e) {
            existingRepo = null;
        }
        return existingRepo == null || currentOwner != null && existingRepo.getId() == currentOwner.getId();
    }

    private String escapeProjectKey(String key) {
        String result = this.escape(key, DefaultExternalMappingHelper.toPredicate(PROJECT_KEY_VALID), DefaultExternalMappingHelper::isValidProjectKeyAppend);
        return StringUtils.left((String)result, (int)128);
    }

    private String escapeProjectName(String externalName) {
        Object result = PROJECT_NAME_REMOVE.matcher(externalName).replaceFirst("");
        if (((String)result).isEmpty()) {
            result = DefaultExternalMappingHelper.escapeChar(externalName.charAt(0)) + externalName.substring(1);
        }
        return StringUtils.left((String)result, (int)128);
    }

    private String escapeRepo(String key) {
        String result = this.escape(key, DefaultExternalMappingHelper.toPredicate(REPO_SLUG_VALID), DefaultExternalMappingHelper::isValidRepoSlugAppend);
        return StringUtils.left((String)result, (int)128);
    }

    private String escape(String str, Predicate<CharSequence> isValidString, IsValidAppend isValidAppend) {
        if (isValidString.test(str)) {
            return str;
        }
        str = Normalizer.normalize(str, Normalizer.Form.NFKD);
        StringBuilder removeCharacters = new StringBuilder();
        StringBuilder escapeCharacters = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (isValidAppend.test(removeCharacters, ch)) {
                removeCharacters.append(ch);
            }
            if (isValidAppend.test(escapeCharacters, ch)) {
                escapeCharacters.append(ch);
                continue;
            }
            escapeCharacters.append(DefaultExternalMappingHelper.escapeChar(ch));
        }
        if (isValidString.test(removeCharacters)) {
            return removeCharacters.toString();
        }
        return escapeCharacters.toString();
    }

    private String generateRandomString(int max) {
        return StringUtils.left((String)this.tokenGenerator.generateToken(), (int)max);
    }

    private static boolean isValidRepoSlugAppend(CharSequence sequence, char append) {
        if (sequence.length() == 0) {
            return CharUtils.isAsciiAlphanumeric((char)append);
        }
        return CharUtils.isAsciiAlphanumeric((char)append) || append == '.' || append == '-' || append == '_';
    }

    private static boolean isValidProjectKeyAppend(CharSequence sequence, char append) {
        if (sequence.length() == 0) {
            return CharUtils.isAsciiAlpha((char)append) || append == '~';
        }
        if (sequence.length() == 1 && sequence.charAt(0) == '~') {
            return CharUtils.isAsciiAlpha((char)append);
        }
        return CharUtils.isAsciiAlphanumeric((char)append) || append == '_' || append == '-';
    }

    private static String escapeChar(char i) {
        return String.format("u%04x", i);
    }

    private static Predicate<CharSequence> toPredicate(Pattern pattern) {
        return str -> pattern.matcher((CharSequence)str).matches();
    }

    private static interface IsValidAppend {
        public boolean test(CharSequence var1, char var2);
    }
}

