/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MinimalExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringValidationHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestRateExceededException;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestUntrustedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.RepositoryMetadataSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.metrics.JmxHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.queue.RequestStatus;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.MetadataSynchronizationResponse;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.DefaultRepositoryLockCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryLockService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.DedupingExecutor;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.FarmMetadataOrchestrator;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.RepositoriesSynchronizationRequest;
import com.atlassian.bitbucket.mirroring.mirror.ProjectSynchronizationFailedEvent;
import com.atlassian.bitbucket.mirroring.mirror.SyncLevel;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="farmMetadataOrchestrator")
public class DefaultFarmMetadataOrchestrator
implements FarmMetadataOrchestrator {
    private static final Logger log = LoggerFactory.getLogger(DefaultFarmMetadataOrchestrator.class);
    private final RequestReplyTopic<RepositoriesSynchronizationRequest, MetadataSynchronizationResponse> bulkRepositoryMetadataTopic;
    private final DedupingExecutor dedupingExecutor;
    private final EventPublisher eventPublisher;
    private final MirrorRepositoryLockService mirrorRepositoryLockService;
    private final MirrorRepositoryService mirrorRepositoryService;
    private final RequestReplyTopic<ExternalProject, Boolean> projectMetadataTopic;
    private final RequestReplyTopic<String, Boolean> repositoryDeleteTopic;
    private final Topic<String> repositoryLockReleaseTopic;
    private final RequestReplyTopic<ExternalRepository, Boolean> singleRepositoryMetadataTopic;
    private final MirroringValidationHelper validationHelper;

    DefaultFarmMetadataOrchestrator(RequestReplyTopic<RepositoriesSynchronizationRequest, MetadataSynchronizationResponse> bulkRepositoryMetadataTopic, EventPublisher eventPublisher, ScheduledExecutorService scheduledExecutorService, MirrorRepositoryLockService mirrorRepositoryLockService, MirrorRepositoryService mirrorRepositoryService, RequestReplyTopic<ExternalProject, Boolean> projectMetadataTopic, RequestReplyTopic<String, Boolean> repositoryDeleteTopic, Topic<String> repositoryLockReleaseTopic, RequestReplyTopic<ExternalRepository, Boolean> singleRepositoryMetadataTopic, MirroringValidationHelper validationHelper) {
        this.bulkRepositoryMetadataTopic = bulkRepositoryMetadataTopic;
        this.eventPublisher = eventPublisher;
        this.mirrorRepositoryLockService = mirrorRepositoryLockService;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.projectMetadataTopic = projectMetadataTopic;
        this.repositoryDeleteTopic = repositoryDeleteTopic;
        this.repositoryLockReleaseTopic = repositoryLockReleaseTopic;
        this.singleRepositoryMetadataTopic = singleRepositoryMetadataTopic;
        this.validationHelper = validationHelper;
        this.dedupingExecutor = new DedupingExecutor(scheduledExecutorService);
    }

    @Override
    public void synchronizeAll(@Nonnull UpstreamServer upstream, @Nonnull SyncLevel syncLevel) {
        Objects.requireNonNull(upstream, "upstream");
        Objects.requireNonNull(syncLevel, "syncLevel");
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstream.getId());
        this.dedupingExecutor.submit(upstream.getId(), new SynchronizeAllTask(this, upstream, syncLevel));
    }

    @Override
    public void synchronizeProject(@Nonnull UpstreamServer upstream, @Nonnull SyncLevel syncLevel, @Nonnull String externalProjectId) {
        Objects.requireNonNull(upstream, "upstream");
        Objects.requireNonNull(syncLevel, "syncLevel");
        Objects.requireNonNull(externalProjectId, "externalProjectId");
        this.validationHelper.checkIsUpstreamUserOrAdmin(upstream.getId());
        this.dedupingExecutor.submit(upstream.getId() + ":" + externalProjectId, new SynchronizeProjectTask(upstream, syncLevel, externalProjectId));
    }

    @Override
    public RequestStatus synchronizeRepository(@Nonnull RepositoryMetadataSynchronizationRequest request) {
        MinimalExternalRepository externalRepository = request.getMinimalExternalRepository();
        try (Ticker ignored = Timers.timerWithMetric((String)JmxHelper.timerName("farm", "synchronize", "metadata", "repository")).start(new String[0]);){
            switch (request.getRequestType()) {
                case CREATE: 
                case MODIFY: {
                    RequestStatus requestStatus = this.synchronizeRepository(externalRepository);
                    return requestStatus;
                }
                case DELETE: {
                    RequestStatus requestStatus = this.deleteRepository(externalRepository);
                    return requestStatus;
                }
            }
            log.error("{}: Unknown request type to synchronize repository", MirrorDescriptionUtils.describe(externalRepository));
        }
        return RequestStatus.processed();
    }

    @Override
    public RequestStatus updateLocalProject(@Nonnull ExternalProject externalProject) {
        Objects.requireNonNull(externalProject, "externalProject");
        try {
            log.debug("{}: Starting project metadata update on mirror farm", MirrorDescriptionUtils.describe(externalProject));
            this.projectMetadataTopic.publish(externalProject);
        }
        catch (Exception e) {
            return RequestStatus.failed(e, String.format("%s: Error updating local project", MirrorDescriptionUtils.describe(externalProject)));
        }
        return RequestStatus.processed();
    }

    private RequestStatus createOrUpdateRepository(MinimalExternalRepository minimalExternalRepository) {
        String externalRepositoryId = minimalExternalRepository.getId();
        DefaultRepositoryLockCallback<RequestStatus> lockCallback = new DefaultRepositoryLockCallback.Builder<RequestStatus>(this.repositoryLockReleaseTopic).lockSuccess(id -> {
            try {
                ExternalRepository externalRepository = this.mirrorRepositoryService.getExternalRepository((String)id);
                return this.publishTopicToSynchronizeRepository(externalRepository);
            }
            catch (NoSuchRepositoryException e) {
                log.debug("{}: Skipping synchronization of repository because it's not found on upstream", MirrorDescriptionUtils.describe(minimalExternalRepository), (Object)e);
                return RequestStatus.processed();
            }
        }).lockFailure(id -> {
            log.debug("{}: Skipping synchronization as lock could not be acquired", MirrorDescriptionUtils.describe(minimalExternalRepository));
            return RequestStatus.lockFailure();
        }).build();
        return this.mirrorRepositoryLockService.performUsingLock(externalRepositoryId, lockCallback);
    }

    private RequestStatus deleteRepository(@Nonnull MinimalExternalRepository externalRepository) {
        Objects.requireNonNull(externalRepository, "externalRepository");
        String externalRepositoryId = externalRepository.getId();
        DefaultRepositoryLockCallback<RequestStatus> lockCallback = new DefaultRepositoryLockCallback.Builder<RequestStatus>(this.repositoryLockReleaseTopic).lockSuccess(id -> this.publishTopicToDeleteRepository(externalRepository)).lockFailure(id -> {
            log.debug("{}: Skipping repository delete as lock could not be acquired", MirrorDescriptionUtils.describe(externalRepository));
            return RequestStatus.lockFailure();
        }).build();
        return this.mirrorRepositoryLockService.performUsingLock(externalRepositoryId, lockCallback);
    }

    private RequestStatus publishTopicToDeleteRepository(MinimalExternalRepository externalRepository) {
        try {
            if (this.repositoryDeleteTopic.publish(externalRepository.getId()).booleanValue()) {
                log.info("{}: Repository deleted successfully on mirror farm", MirrorDescriptionUtils.describe(externalRepository));
            } else {
                log.warn("{}: Repository may not be deleted on mirror farm", MirrorDescriptionUtils.describe(externalRepository));
            }
        }
        catch (Exception e) {
            return RequestStatus.failed(e, String.format("%s: Error deleting repository", MirrorDescriptionUtils.describe(externalRepository)));
        }
        return RequestStatus.processed();
    }

    private RequestStatus publishTopicToSynchronizeRepository(ExternalRepository externalRepository) {
        try {
            log.debug("{}: Starting synchronization of repository on mirror farm", MirrorDescriptionUtils.describe(externalRepository));
            if (this.singleRepositoryMetadataTopic.publish(externalRepository).booleanValue()) {
                log.debug("{}: Synchronization of repository on mirror farm is done", MirrorDescriptionUtils.describe(externalRepository));
            } else {
                log.warn("{}: Synchronization of repository on mirror farm is not done", MirrorDescriptionUtils.describe(externalRepository));
            }
        }
        catch (Exception e) {
            return RequestStatus.failed(e, String.format("%s: Error during synchronization of new repository on mirror farm", MirrorDescriptionUtils.describe(externalRepository)));
        }
        return RequestStatus.processed();
    }

    private RequestStatus synchronizeRepository(@Nonnull MinimalExternalRepository minimalExternalRepository) {
        Objects.requireNonNull(minimalExternalRepository, "minimalExternalRepository");
        if (this.mirrorRepositoryService.isMirrored(minimalExternalRepository)) {
            return this.createOrUpdateRepository(minimalExternalRepository);
        }
        if (this.mirrorRepositoryService.isLocalRepositoryPresent(minimalExternalRepository.getId())) {
            return this.deleteRepository(minimalExternalRepository);
        }
        log.trace("{}: Skipping synchronization of repository because the repository can neither be mirrored nor present locally", MirrorDescriptionUtils.describe(minimalExternalRepository));
        return RequestStatus.processed();
    }

    class SynchronizeAllTask
    extends AbstractSynchronizationTask {
        private SynchronizeAllTask(DefaultFarmMetadataOrchestrator this$0, UpstreamServer upstream, SyncLevel syncLevel) {
            super(upstream, syncLevel, null);
        }

        @Override
        public void run() {
            Object upstreamDescription = MirrorDescriptionUtils.describe(this.upstream);
            try (Ticker ignored = Timers.timerWithMetric((String)JmxHelper.timerName("farm", "synchronize", "metadata", "all-projects")).start(new String[0]);){
                this.syncUpstreamRepositories(upstreamDescription);
            }
            catch (UpstreamRequestRateExceededException e) {
                log.warn("{}: Full synchronization failed because an upstream request rate limit has been exceeded. Aborting full sync", upstreamDescription);
            }
            catch (UpstreamRequestUntrustedException e) {
                log.info("{}: Full synchronization failed because the upstream rejected the mirror's credentials. Perhaps the mirror is disabled in the upstream?", upstreamDescription);
            }
            catch (RuntimeException e) {
                log.error("{}: Full synchronization failed", upstreamDescription, (Object)e);
            }
        }
    }

    class SynchronizeProjectTask
    extends AbstractSynchronizationTask {
        private SynchronizeProjectTask(UpstreamServer upstream, SyncLevel syncLevel, String externalProjectId) {
            super(upstream, syncLevel, Objects.requireNonNull(externalProjectId, "externalProjectId"));
        }

        @Override
        public void run() {
            Object upstreamDescription = MirrorDescriptionUtils.describe(this.upstream);
            try (Ticker ignored = Timers.timerWithMetric((String)JmxHelper.timerName("farm", "synchronize", "metadata", "single-project")).start(new String[0]);){
                this.syncUpstreamRepositories(upstreamDescription);
            }
            catch (UpstreamRequestRateExceededException e) {
                log.warn("{}: Project synchronization failed because an upstream request rate limit has been exceeded. Aborting project sync", upstreamDescription);
                DefaultFarmMetadataOrchestrator.this.eventPublisher.publish((Object)new ProjectSynchronizationFailedEvent(this, this.externalProjectId, this.upstream.getId(), (Exception)((Object)e)));
            }
            catch (UpstreamRequestUntrustedException e) {
                log.info("{}: Project synchronization failed because the upstream rejected the mirror's credentials. Perhaps the mirror is disabled in the upstream?", upstreamDescription);
                DefaultFarmMetadataOrchestrator.this.eventPublisher.publish((Object)new ProjectSynchronizationFailedEvent(this, this.externalProjectId, this.upstream.getId(), (Exception)((Object)e)));
            }
            catch (RuntimeException e) {
                log.error("{}: Project synchronization failed", upstreamDescription, (Object)e);
                DefaultFarmMetadataOrchestrator.this.eventPublisher.publish((Object)new ProjectSynchronizationFailedEvent(this, this.externalProjectId, this.upstream.getId(), e));
            }
        }
    }

    abstract class AbstractSynchronizationTask
    implements Runnable {
        protected final String externalProjectId;
        protected final UpstreamServer upstream;
        private final SyncLevel syncLevel;

        AbstractSynchronizationTask(@Nonnull UpstreamServer upstream, @Nullable SyncLevel syncLevel, String externalProjectId) {
            this.upstream = Objects.requireNonNull(upstream, "upstream");
            this.syncLevel = Objects.requireNonNull(syncLevel, "syncLevel");
            this.externalProjectId = externalProjectId;
        }

        void syncUpstreamRepositories(@Nonnull Object upstreamDescription) {
            log.debug("{}: Starting repository metadata synchronization", upstreamDescription);
            RepositoriesSynchronizationRequest request = new RepositoriesSynchronizationRequest.Builder().project(this.externalProjectId).syncLevel(this.syncLevel).build();
            DefaultFarmMetadataOrchestrator.this.bulkRepositoryMetadataTopic.publish(request);
            log.debug("{}: Repository metadata synchronization is complete", upstreamDescription);
        }
    }
}

