/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.internal.mirroring.mirror.sync.MirrorBranchHelper;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultMirrorBranchHelper
implements MirrorBranchHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirrorBranchHelper.class);
    private final RefService refService;

    @Autowired
    public DefaultMirrorBranchHelper(RefService refService) {
        this.refService = refService;
    }

    @Override
    @Nonnull
    public Optional<String> getDefaultBranch(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        try {
            return Optional.of(this.refService.getDefaultBranch(repository).getId());
        }
        catch (NoDefaultBranchException e) {
            return Optional.ofNullable(e.getBranchName());
        }
    }

    @Override
    public void updateDefaultBranch(@Nonnull String newDefaultBranchId, @Nonnull Repository repository) {
        Objects.requireNonNull(newDefaultBranchId, "newDefaultBranchId");
        Objects.requireNonNull(repository, "repository");
        if (newDefaultBranchId.equals(this.getDefaultBranch(repository).orElse(null))) {
            log.debug("{}: The default branch is already {}", (Object)repository, (Object)newDefaultBranchId);
            return;
        }
        this.refService.setDefaultBranch(repository, newDefaultBranchId);
    }
}

