/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestRateExceededException;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestUntrustedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorProjectService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.RepositoriesSynchronizationRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SyncResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.sync.SynchronizationHelper;
import com.atlassian.bitbucket.mirroring.mirror.FullSynchronizationEvent;
import com.atlassian.bitbucket.mirroring.mirror.FullSynchronizationFailedEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullSynchronizationHelper
implements SynchronizationHelper {
    private static final Logger log = LoggerFactory.getLogger(FullSynchronizationHelper.class);
    private final EventPublisher eventPublisher;
    private final MirrorProjectService mirrorProjectService;
    private final MirrorRepositoryService mirrorRepositoryService;

    FullSynchronizationHelper(@Nonnull EventPublisher eventPublisher, @Nonnull MirrorProjectService mirrorProjectService, @Nonnull MirrorRepositoryService mirrorRepositoryService) {
        this.eventPublisher = Objects.requireNonNull(eventPublisher, "eventPublisher");
        this.mirrorProjectService = Objects.requireNonNull(mirrorProjectService, "mirrorProjectService");
        this.mirrorRepositoryService = Objects.requireNonNull(mirrorRepositoryService, "mirrorRepositoryService");
    }

    @Override
    public void deleteProjectsWithoutRepositories(@Nonnull UpstreamServer upstreamServer) {
        Objects.requireNonNull(upstreamServer, "upstreamServer");
        this.mirrorProjectService.deleteProjectsWithoutRepositories(Objects.requireNonNull(upstreamServer));
    }

    @Override
    @Nonnull
    public Set<String> getAllLocallyKnownExternalRepositoryIds(@Nonnull UpstreamServer upstreamServer) {
        Objects.requireNonNull(upstreamServer, "upstreamServer");
        return this.mirrorRepositoryService.getAllLocallyKnownExternalRepositoryIds();
    }

    @Override
    public void notifySynchronizationComplete(@Nonnull UpstreamServer upstreamServer, @Nonnull RepositoriesSynchronizationRequest request, @Nonnull Date startDate, @Nonnull SyncResult syncResult) {
        Objects.requireNonNull(upstreamServer, "upstreamServer");
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(startDate, "startDate");
        Objects.requireNonNull(syncResult, "syncResult");
        this.eventPublisher.publish((Object)new FullSynchronizationEvent(this, startDate, upstreamServer, syncResult.getSyncedExternalProjectIds()));
    }

    @Override
    public void notifySynchronizationFailed(@Nonnull Object source, @Nonnull UpstreamServer upstreamServer, @Nonnull Date startDate, @Nonnull RuntimeException exception) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(upstreamServer, "upstreamServer");
        Objects.requireNonNull(startDate, "startDate");
        Objects.requireNonNull(exception, "exception");
        Object upstreamDescription = MirrorDescriptionUtils.describe(upstreamServer);
        if (exception instanceof UpstreamRequestRateExceededException) {
            log.warn("{}: full synchronization failed because an upstream request rate limit has been exceeded. Aborting full sync", upstreamDescription);
        } else if (exception instanceof UpstreamRequestUntrustedException) {
            log.info("{}: full synchronization failed because the upstream rejected the mirror's credentials. Perhaps the mirror is disabled in the upstream?", upstreamDescription);
        } else {
            log.error("{}: full synchronization failed", upstreamDescription, (Object)exception);
        }
        this.eventPublisher.publish((Object)new FullSynchronizationFailedEvent(source, startDate, upstreamServer, exception));
    }
}

