/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.sync;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCallback;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorRefChangeCallback
implements MirrorSyncCallback {
    private static final Logger log = LoggerFactory.getLogger(MirrorRefChangeCallback.class);
    private final ImmutableList.Builder<RefChange> changes;
    private final ImmutableList.Builder<MinimalRef> failedRefs;
    private final Repository repository;
    private int count;

    public MirrorRefChangeCallback(@Nonnull Repository repository) {
        this.repository = Objects.requireNonNull(repository, "repository");
        this.changes = ImmutableList.builder();
        this.failedRefs = ImmutableList.builder();
    }

    @Nonnull
    public List<RefChange> getChanges() {
        return this.changes.build();
    }

    public int getCount() {
        return this.count;
    }

    @Nonnull
    public Collection<MinimalRef> getFailedRefs() {
        return this.failedRefs.build();
    }

    public boolean onFailedRef(@Nonnull MinimalRef ref) throws IOException {
        this.failedRefs.add((Object)ref);
        return true;
    }

    public boolean onRefChange(@Nonnull RefChange refChange) {
        ++this.count;
        this.changes.add((Object)refChange);
        if (log.isDebugEnabled()) {
            log.debug("{}: synced {} ({})", new Object[]{this.repository, refChange.getRef().getId(), StringUtils.lowerCase((String)refChange.getType().name())});
        }
        return true;
    }
}

